/*
 * Decompiled with CFR 0.152.
 */
package magicstone.item;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import magicstone.procedures.AbyssalEnergySpearActionProcedure;
import magicstone.procedures.AbyssalEnergySpearSoundActionProcedure;
import magicstone.procedures.Set_PullProcedure;
import magicstone.procedures.Set_PullingProcedure;
import magicstone.procedures.TabooMagicStoneParticleProcedure;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class AbyssalEnergySpearItem
extends Item {
    public AbyssalEnergySpearItem(Item.Properties properties) {
        super(properties.rarity(Rarity.EPIC).durability(1000).fireResistant().attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 665.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemstack) {
        return ItemUseAnimation.SPEAR;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 40;
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        AbyssalEnergySpearActionProcedure.execute((Entity)entity);
        return retval;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        AbyssalEnergySpearSoundActionProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)sourceentity);
        return true;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            TabooMagicStoneParticleProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ());
        }
    }

    public record PullingProperty() implements RangeSelectItemModelProperty
    {
        public static final MapCodec<PullingProperty> MAP_CODEC = MapCodec.unit((Object)new PullingProperty());

        public float get(ItemStack itemStackToRender, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
            return (float)Set_PullingProcedure.execute((Entity)entity, itemStackToRender);
        }

        public MapCodec<PullingProperty> type() {
            return MAP_CODEC;
        }
    }

    public record PullProperty() implements RangeSelectItemModelProperty
    {
        public static final MapCodec<PullProperty> MAP_CODEC = MapCodec.unit((Object)new PullProperty());

        public float get(ItemStack itemStackToRender, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
            return (float)Set_PullProcedure.execute((Entity)entity);
        }

        public MapCodec<PullProperty> type() {
            return MAP_CODEC;
        }
    }
}

