/*
 * Decompiled with CFR 0.152.
 */
package magicstone.item;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import magicstone.procedures.MagicSwordSoundActionProcedure;
import magicstone.procedures.Set_PullProcedure;
import magicstone.procedures.Set_PullingProcedure;
import magicstone.procedures.SilentWishHitActionProcedure;
import magicstone.procedures.SilentWishSoundActionProcedure;
import magicstone.procedures.SilentWishTestActionProcedure;
import magicstone.procedures.SilentWishTickActionProcedure;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class SilentWishItem
extends Item {
    public SilentWishItem(Item.Properties properties) {
        super(properties.rarity(Rarity.EPIC).durability(1000).fireResistant().attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 179.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()).enchantable(100));
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemstack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 72000;
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState state) {
        return 10.0f;
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        SilentWishSoundActionProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ());
        return ar;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        SilentWishHitActionProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        return true;
    }

    public void onCraftedBy(ItemStack itemstack, Level world, Player entity) {
        super.onCraftedBy(itemstack, world, entity);
        MagicSwordSoundActionProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ());
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            SilentWishTestActionProcedure.execute(entity, itemstack);
        }
    }

    public boolean releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        SilentWishTickActionProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
        return super.releaseUsing(itemstack, world, entity, time);
    }

    public record SetPullingProperty() implements RangeSelectItemModelProperty
    {
        public static final MapCodec<SetPullingProperty> MAP_CODEC = MapCodec.unit((Object)new SetPullingProperty());

        public float get(ItemStack itemStackToRender, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
            return (float)Set_PullingProcedure.execute((Entity)entity, itemStackToRender);
        }

        public MapCodec<SetPullingProperty> type() {
            return MAP_CODEC;
        }
    }

    public record SetPullProperty() implements RangeSelectItemModelProperty
    {
        public static final MapCodec<SetPullProperty> MAP_CODEC = MapCodec.unit((Object)new SetPullProperty());

        public float get(ItemStack itemStackToRender, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
            return (float)Set_PullProcedure.execute((Entity)entity);
        }

        public MapCodec<SetPullProperty> type() {
            return MAP_CODEC;
        }
    }
}

