/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.entity;

import magic_stone.entity.ApprenticeOfTheSorcererEntity;
import magic_stone.entity.DreamlandGuardiansEntity;
import magic_stone.entity.MasterOfMagicEntity;
import magic_stone.procedures.InfectedMengLiActionProcedure;
import magic_stone.procedures.InfectedMengLiDropActionProcedure;
import magic_stone.procedures.MengLiHurtActionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class InfectedMengLiEntity
extends Monster {
    public InfectedMengLiEntity(EntityType<InfectedMengLiEntity> type, Level world) {
        super(type, world);
        this.xpReward = 10;
        this.setNoAi(false);
        this.refreshDimensions();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.75f));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.1));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, FlyingMob.class, false, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, false, true));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, SpellcasterIllager.class, false, true));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false, true));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, true));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, ApprenticeOfTheSorcererEntity.class, false, true));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, MasterOfMagicEntity.class, false, true));
        this.targetSelector.addGoal(13, (Goal)new NearestAttackableTargetGoal((Mob)this, DreamlandGuardiansEntity.class, false, true));
        this.goalSelector.addGoal(14, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        InfectedMengLiEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        MengLiHurtActionProcedure.execute((LevelAccessor)world, (Entity)entity, sourceentity);
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        InfectedMengLiDropActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void baseTick() {
        super.baseTick();
        InfectedMengLiActionProcedure.execute((Entity)this);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(0.7f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.4);
        builder = builder.add(Attributes.MAX_HEALTH, 40.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 8.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 2.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.4);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        return builder;
    }
}

