/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.entity;

import javax.annotation.Nullable;
import magic_stone.entity.BaneMageEntity;
import magic_stone.entity.EnemySlaveEntity;
import magic_stone.entity.FifthOrderFerociousGhostEntity;
import magic_stone.entity.FifthOrderSorcererEntity;
import magic_stone.entity.FirstOrderFerociousGhostEntity;
import magic_stone.entity.FirstOrderImpactShellsEntity;
import magic_stone.entity.FirstOrderSorcererEntity;
import magic_stone.entity.FourthOrderFerociousGhostEntity;
import magic_stone.entity.FourthOrderSorcererEntity;
import magic_stone.entity.SecondOrderFerociousGhostEntity;
import magic_stone.entity.SecondOrderSorcererEntity;
import magic_stone.entity.StrangeCreatureEntity;
import magic_stone.entity.ThirdOrderFerociousGhostEntity;
import magic_stone.entity.ThirdOrderSorcererEntity;
import magic_stone.entity.WickedDiscipleEntity;
import magic_stone.init.MagicStoneModEntities;
import magic_stone.init.MagicStoneModItems;
import magic_stone.procedures.FourthOrderEffectsActionProcedure;
import magic_stone.procedures.FourthOrderSorcererDropsActionProcedure;
import magic_stone.procedures.MasterOfMagicTradeActionProcedure;
import magic_stone.procedures.SorcererSpecialActionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class MasterOfMagicEntity
extends Monster
implements RangedAttackMob {
    public MasterOfMagicEntity(EntityType<MasterOfMagicEntity> type, Level world) {
        super(type, world);
        this.xpReward = 40;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)MagicStoneModItems.BASIC_FOURTH_ORDER_IMPACT_CURSE_STONE.get()));
    }

    protected void registerGoals() {
        super.registerGoals();
        this.getNavigation().getNodeEvaluator().setCanOpenDoors(true);
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, EnemySlaveEntity.class, true, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, BaneMageEntity.class, true, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, FirstOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, ThirdOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, FourthOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, FifthOrderSorcererEntity.class, true, true));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, StrangeCreatureEntity.class, true, true));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, true));
        this.targetSelector.addGoal(13, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombieVillager.class, true, true));
        this.targetSelector.addGoal(14, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombifiedPiglin.class, true, true));
        this.targetSelector.addGoal(15, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true, true));
        this.targetSelector.addGoal(16, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, true, true));
        this.targetSelector.addGoal(17, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true, true));
        this.targetSelector.addGoal(18, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true, true));
        this.targetSelector.addGoal(19, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderDragon.class, true, true));
        this.targetSelector.addGoal(20, (Goal)new NearestAttackableTargetGoal((Mob)this, Blaze.class, true, true));
        this.targetSelector.addGoal(21, (Goal)new NearestAttackableTargetGoal((Mob)this, CaveSpider.class, true, true));
        this.targetSelector.addGoal(22, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, true, true));
        this.targetSelector.addGoal(23, (Goal)new NearestAttackableTargetGoal((Mob)this, Drowned.class, true, true));
        this.targetSelector.addGoal(24, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, true, true));
        this.targetSelector.addGoal(25, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, true));
        this.targetSelector.addGoal(26, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherBoss.class, true, true));
        this.targetSelector.addGoal(27, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true, true));
        this.targetSelector.addGoal(28, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true, true));
        this.targetSelector.addGoal(29, (Goal)new NearestAttackableTargetGoal((Mob)this, Ghast.class, true, true));
        this.targetSelector.addGoal(30, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, true, true));
        this.targetSelector.addGoal(31, (Goal)new NearestAttackableTargetGoal((Mob)this, Guardian.class, true, true));
        this.targetSelector.addGoal(32, (Goal)new NearestAttackableTargetGoal((Mob)this, Stray.class, true, true));
        this.targetSelector.addGoal(33, (Goal)new NearestAttackableTargetGoal((Mob)this, Phantom.class, true, true));
        this.targetSelector.addGoal(34, (Goal)new NearestAttackableTargetGoal((Mob)this, Vindicator.class, true, true));
        this.targetSelector.addGoal(35, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, true, true));
        this.targetSelector.addGoal(36, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, true, true));
        this.targetSelector.addGoal(37, (Goal)new NearestAttackableTargetGoal((Mob)this, Evoker.class, true, true));
        this.targetSelector.addGoal(38, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true, true));
        this.targetSelector.addGoal(39, (Goal)new NearestAttackableTargetGoal((Mob)this, PiglinBrute.class, true, true));
        this.targetSelector.addGoal(40, (Goal)new NearestAttackableTargetGoal((Mob)this, Vex.class, true, true));
        this.targetSelector.addGoal(41, (Goal)new NearestAttackableTargetGoal((Mob)this, MagmaCube.class, true, true));
        this.targetSelector.addGoal(42, (Goal)new NearestAttackableTargetGoal((Mob)this, Silverfish.class, true, true));
        this.targetSelector.addGoal(43, (Goal)new NearestAttackableTargetGoal((Mob)this, FirstOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(44, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(45, (Goal)new NearestAttackableTargetGoal((Mob)this, ThirdOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(46, (Goal)new NearestAttackableTargetGoal((Mob)this, FourthOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(47, (Goal)new NearestAttackableTargetGoal((Mob)this, FifthOrderFerociousGhostEntity.class, true, true));
        this.targetSelector.addGoal(48, (Goal)new NearestAttackableTargetGoal((Mob)this, WickedDiscipleEntity.class, true, true));
        this.goalSelector.addGoal(49, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(50, (Goal)new OpenDoorGoal((Mob)this, false));
        this.goalSelector.addGoal(51, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(52, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 28, 64.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.villager.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.villager.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.villager.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        MasterOfMagicEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        SorcererSpecialActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        FourthOrderSorcererDropsActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        FourthOrderEffectsActionProcedure.execute((Entity)this);
        return retval;
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        MasterOfMagicEntity entity = this;
        Level world = this.level();
        MasterOfMagicTradeActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
        return retval;
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        FirstOrderImpactShellsEntity.shoot((LivingEntity)this, target);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)MagicStoneModEntities.MASTER_OF_MAGIC.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 500.0);
        builder = builder.add(Attributes.ARMOR, 15.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.8);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.4);
        return builder;
    }
}

