/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.entity;

import java.util.EnumSet;
import magic_stone.entity.ApprenticeOfTheSorcererEntity;
import magic_stone.entity.FifthOrderFerociousGhostEntity;
import magic_stone.entity.FifthOrderMagicGhostEntity;
import magic_stone.entity.FifthOrderSorcererEntity;
import magic_stone.entity.FirstOrderFerociousGhostEntity;
import magic_stone.entity.FirstOrderMagicGhostEntity;
import magic_stone.entity.FirstOrderSorcererEntity;
import magic_stone.entity.FourthOrderFerociousGhostEntity;
import magic_stone.entity.FourthOrderMagicGhostEntity;
import magic_stone.entity.FourthOrderSorcererEntity;
import magic_stone.entity.MasterOfMagicEntity;
import magic_stone.entity.MengLiEntity;
import magic_stone.entity.SecondOrderFerociousGhostEntity;
import magic_stone.entity.SecondOrderMagicGhostEntity;
import magic_stone.entity.SecondOrderSorcererEntity;
import magic_stone.entity.SlaveEntity;
import magic_stone.entity.ThirdOrderFerociousGhostEntity;
import magic_stone.entity.ThirdOrderMagicGhostEntity;
import magic_stone.entity.ThirdOrderSorcererEntity;
import magic_stone.init.MagicStoneModEntities;
import magic_stone.procedures.StrangeCreatureDeadActionProcedure;
import magic_stone.procedures.StrangeCreatureEffectsActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class StrangeCreatureEntity
extends Monster {
    public StrangeCreatureEntity(EntityType<StrangeCreatureEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1000;
        this.setNoAi(false);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return StrangeCreatureEntity.this.getTarget() != null && !StrangeCreatureEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return StrangeCreatureEntity.this.getMoveControl().hasWanted() && StrangeCreatureEntity.this.getTarget() != null && StrangeCreatureEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = StrangeCreatureEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                StrangeCreatureEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 10.0);
            }

            public void tick() {
                LivingEntity livingentity = StrangeCreatureEntity.this.getTarget();
                if (StrangeCreatureEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    StrangeCreatureEntity.this.doHurtTarget(1.getServerLevel((Entity)livingentity), (Entity)livingentity);
                } else {
                    double d0 = StrangeCreatureEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 64.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        StrangeCreatureEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 10.0);
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 0.8, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 3.0, 20){

            protected Vec3 getPosition() {
                RandomSource random = StrangeCreatureEntity.this.getRandom();
                double dir_x = StrangeCreatureEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = StrangeCreatureEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = StrangeCreatureEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, FirstOrderSorcererEntity.class, false, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondOrderSorcererEntity.class, false, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, ThirdOrderSorcererEntity.class, false, true));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, FourthOrderSorcererEntity.class, false, true));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, FifthOrderSorcererEntity.class, false, true));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, SlaveEntity.class, false, true));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, FirstOrderMagicGhostEntity.class, false, true));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondOrderMagicGhostEntity.class, false, true));
        this.targetSelector.addGoal(13, (Goal)new NearestAttackableTargetGoal((Mob)this, ThirdOrderMagicGhostEntity.class, false, true));
        this.targetSelector.addGoal(14, (Goal)new NearestAttackableTargetGoal((Mob)this, FourthOrderMagicGhostEntity.class, false, true));
        this.targetSelector.addGoal(15, (Goal)new NearestAttackableTargetGoal((Mob)this, FifthOrderMagicGhostEntity.class, false, true));
        this.targetSelector.addGoal(16, (Goal)new NearestAttackableTargetGoal((Mob)this, FirstOrderFerociousGhostEntity.class, false, true));
        this.targetSelector.addGoal(17, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondOrderFerociousGhostEntity.class, false, true));
        this.targetSelector.addGoal(18, (Goal)new NearestAttackableTargetGoal((Mob)this, ThirdOrderFerociousGhostEntity.class, false, true));
        this.targetSelector.addGoal(19, (Goal)new NearestAttackableTargetGoal((Mob)this, FourthOrderFerociousGhostEntity.class, false, true));
        this.targetSelector.addGoal(20, (Goal)new NearestAttackableTargetGoal((Mob)this, FifthOrderFerociousGhostEntity.class, false, true));
        this.targetSelector.addGoal(21, (Goal)new NearestAttackableTargetGoal((Mob)this, Allay.class, false, true));
        this.targetSelector.addGoal(22, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, false, true));
        this.targetSelector.addGoal(23, (Goal)new NearestAttackableTargetGoal((Mob)this, Bat.class, false, true));
        this.targetSelector.addGoal(24, (Goal)new NearestAttackableTargetGoal((Mob)this, Bee.class, false, true));
        this.targetSelector.addGoal(25, (Goal)new NearestAttackableTargetGoal((Mob)this, Blaze.class, false, true));
        this.targetSelector.addGoal(26, (Goal)new NearestAttackableTargetGoal((Mob)this, Camel.class, false, true));
        this.targetSelector.addGoal(27, (Goal)new NearestAttackableTargetGoal((Mob)this, Cat.class, false, true));
        this.targetSelector.addGoal(28, (Goal)new NearestAttackableTargetGoal((Mob)this, CaveSpider.class, false, true));
        this.targetSelector.addGoal(29, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, false, true));
        this.targetSelector.addGoal(30, (Goal)new NearestAttackableTargetGoal((Mob)this, Cod.class, false, true));
        this.targetSelector.addGoal(31, (Goal)new NearestAttackableTargetGoal((Mob)this, Cow.class, false, true));
        this.targetSelector.addGoal(32, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, false, true));
        this.targetSelector.addGoal(33, (Goal)new NearestAttackableTargetGoal((Mob)this, Dolphin.class, false, true));
        this.targetSelector.addGoal(34, (Goal)new NearestAttackableTargetGoal((Mob)this, Donkey.class, false, true));
        this.targetSelector.addGoal(35, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderDragon.class, false, true));
        this.targetSelector.addGoal(36, (Goal)new NearestAttackableTargetGoal((Mob)this, Drowned.class, false, true));
        this.targetSelector.addGoal(37, (Goal)new NearestAttackableTargetGoal((Mob)this, ElderGuardian.class, false, true));
        this.targetSelector.addGoal(38, (Goal)new NearestAttackableTargetGoal((Mob)this, EndCrystal.class, false, true));
        this.targetSelector.addGoal(39, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderMan.class, false, true));
        this.targetSelector.addGoal(40, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, false, true));
        this.targetSelector.addGoal(41, (Goal)new NearestAttackableTargetGoal((Mob)this, Evoker.class, false, true));
        this.targetSelector.addGoal(42, (Goal)new NearestAttackableTargetGoal((Mob)this, Fox.class, false, true));
        this.targetSelector.addGoal(43, (Goal)new NearestAttackableTargetGoal((Mob)this, Frog.class, false, true));
        this.targetSelector.addGoal(44, (Goal)new NearestAttackableTargetGoal((Mob)this, Ghast.class, false, true));
        this.targetSelector.addGoal(45, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, true));
        this.targetSelector.addGoal(46, (Goal)new NearestAttackableTargetGoal((Mob)this, GlowSquid.class, false, true));
        this.targetSelector.addGoal(47, (Goal)new NearestAttackableTargetGoal((Mob)this, Guardian.class, false, true));
        this.targetSelector.addGoal(48, (Goal)new NearestAttackableTargetGoal((Mob)this, Hoglin.class, false, true));
        this.targetSelector.addGoal(49, (Goal)new NearestAttackableTargetGoal((Mob)this, Horse.class, false, true));
        this.targetSelector.addGoal(50, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, false, true));
        this.targetSelector.addGoal(51, (Goal)new NearestAttackableTargetGoal((Mob)this, Illusioner.class, false, true));
        this.targetSelector.addGoal(52, (Goal)new NearestAttackableTargetGoal((Mob)this, Llama.class, false, true));
        this.targetSelector.addGoal(53, (Goal)new NearestAttackableTargetGoal((Mob)this, MagmaCube.class, false, true));
        this.targetSelector.addGoal(54, (Goal)new NearestAttackableTargetGoal((Mob)this, Mule.class, false, true));
        this.targetSelector.addGoal(55, (Goal)new NearestAttackableTargetGoal((Mob)this, Ocelot.class, false, true));
        this.targetSelector.addGoal(56, (Goal)new NearestAttackableTargetGoal((Mob)this, Panda.class, false, true));
        this.targetSelector.addGoal(57, (Goal)new NearestAttackableTargetGoal((Mob)this, Parrot.class, false, true));
        this.targetSelector.addGoal(58, (Goal)new NearestAttackableTargetGoal((Mob)this, Phantom.class, false, true));
        this.targetSelector.addGoal(59, (Goal)new NearestAttackableTargetGoal((Mob)this, Pig.class, false, true));
        this.targetSelector.addGoal(60, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, false, true));
        this.targetSelector.addGoal(61, (Goal)new NearestAttackableTargetGoal((Mob)this, PiglinBrute.class, false, true));
        this.targetSelector.addGoal(62, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.targetSelector.addGoal(63, (Goal)new NearestAttackableTargetGoal((Mob)this, PolarBear.class, false, true));
        this.targetSelector.addGoal(64, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, false, true));
        this.targetSelector.addGoal(65, (Goal)new NearestAttackableTargetGoal((Mob)this, Pufferfish.class, false, true));
        this.targetSelector.addGoal(66, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, false, true));
        this.targetSelector.addGoal(67, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, false, true));
        this.targetSelector.addGoal(68, (Goal)new NearestAttackableTargetGoal((Mob)this, Salmon.class, false, true));
        this.targetSelector.addGoal(69, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, true));
        this.targetSelector.addGoal(70, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, false, true));
        this.targetSelector.addGoal(71, (Goal)new NearestAttackableTargetGoal((Mob)this, Shulker.class, false, true));
        this.targetSelector.addGoal(72, (Goal)new NearestAttackableTargetGoal((Mob)this, Silverfish.class, false, true));
        this.targetSelector.addGoal(73, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, false, true));
        this.targetSelector.addGoal(74, (Goal)new NearestAttackableTargetGoal((Mob)this, SkeletonHorse.class, false, true));
        this.targetSelector.addGoal(75, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, false, true));
        this.targetSelector.addGoal(76, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, false, true));
        this.targetSelector.addGoal(77, (Goal)new NearestAttackableTargetGoal((Mob)this, Strider.class, false, true));
        this.targetSelector.addGoal(78, (Goal)new NearestAttackableTargetGoal((Mob)this, Stray.class, false, true));
        this.targetSelector.addGoal(79, (Goal)new NearestAttackableTargetGoal((Mob)this, TropicalFish.class, false, true));
        this.targetSelector.addGoal(80, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, false, true));
        this.targetSelector.addGoal(81, (Goal)new NearestAttackableTargetGoal((Mob)this, Vex.class, false, true));
        this.targetSelector.addGoal(82, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, true));
        this.targetSelector.addGoal(83, (Goal)new NearestAttackableTargetGoal((Mob)this, Vindicator.class, false, true));
        this.targetSelector.addGoal(84, (Goal)new NearestAttackableTargetGoal((Mob)this, WanderingTrader.class, false, true));
        this.targetSelector.addGoal(85, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, false, true));
        this.targetSelector.addGoal(86, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, false, true));
        this.targetSelector.addGoal(87, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, false, true));
        this.targetSelector.addGoal(88, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherBoss.class, false, true));
        this.targetSelector.addGoal(89, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, false, true));
        this.targetSelector.addGoal(90, (Goal)new NearestAttackableTargetGoal((Mob)this, Zoglin.class, false, true));
        this.targetSelector.addGoal(91, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombieVillager.class, false, true));
        this.targetSelector.addGoal(92, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombifiedPiglin.class, false, true));
        this.targetSelector.addGoal(93, (Goal)new NearestAttackableTargetGoal((Mob)this, MasterOfMagicEntity.class, false, true));
        this.targetSelector.addGoal(94, (Goal)new NearestAttackableTargetGoal((Mob)this, ApprenticeOfTheSorcererEntity.class, false, true));
        this.targetSelector.addGoal(95, (Goal)new NearestAttackableTargetGoal((Mob)this, MengLiEntity.class, false, true));
        this.targetSelector.addGoal(96, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(98, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"ambient.cave"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        StrangeCreatureDeadActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), source);
    }

    public void baseTick() {
        super.baseTick();
        StrangeCreatureEffectsActionProcedure.execute((Entity)this);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)MagicStoneModEntities.STRANGE_CREATURE.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.0);
        builder = builder.add(Attributes.MAX_HEALTH, 1024.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 2000.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 5.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 20.0);
        builder = builder.add(Attributes.FLYING_SPEED, 1.0);
        return builder;
    }
}

