/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.init;

import magic_stone.potion.AbyssalEnergyCirculationMobEffect;
import magic_stone.potion.AncientCirculationMobEffect;
import magic_stone.potion.BackupMagicEnergyMobEffect;
import magic_stone.potion.BlazeboundMobEffect;
import magic_stone.potion.BlessingMobEffect;
import magic_stone.potion.BurningHeartMobEffect;
import magic_stone.potion.ClearCooldownMobEffect;
import magic_stone.potion.CombatStateMobEffect;
import magic_stone.potion.DestructiveEnergyBurstMobEffect;
import magic_stone.potion.DimensionTearingEnergyBurstMobEffect;
import magic_stone.potion.DisasterQuellingCirculationMobEffect;
import magic_stone.potion.ErosionMobEffect;
import magic_stone.potion.FateCirculationMobEffect;
import magic_stone.potion.FlyingMobEffect;
import magic_stone.potion.FrostboundMobEffect;
import magic_stone.potion.GaleboundMobEffect;
import magic_stone.potion.HeartWrenchingEffectMobEffect;
import magic_stone.potion.ImprisonmentMobEffect;
import magic_stone.potion.InfinityCirculationMobEffect;
import magic_stone.potion.InterferenceMobEffect;
import magic_stone.potion.MagicDurationTimerMobEffect;
import magic_stone.potion.MagicEnergyMobEffect;
import magic_stone.potion.MagicGhostMobEffect;
import magic_stone.potion.MagicalBodyMobEffect;
import magic_stone.potion.MindControlMobEffect;
import magic_stone.potion.OrderCirculationMobEffect;
import magic_stone.potion.OrderSpellCooldownMobEffect;
import magic_stone.potion.OriginCirculationMobEffect;
import magic_stone.potion.OriginMagicParticleMobEffect;
import magic_stone.potion.SanityMobEffect;
import magic_stone.potion.SelectMobEffect;
import magic_stone.potion.SpellCooldownMobEffect;
import magic_stone.potion.UndyingCirculationMobEffect;
import magic_stone.procedures.FlyingEffectEndActionProcedure;
import magic_stone.procedures.MagicDurationTimerEndActionProcedure;
import magic_stone.procedures.MindControlEffectEndActionProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class MagicStoneModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"magic_stone");
    public static final DeferredHolder<MobEffect, MobEffect> MAGIC_DURATION_TIMER = REGISTRY.register("magic_duration_timer", () -> new MagicDurationTimerMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INTERFERENCE = REGISTRY.register("interference", () -> new InterferenceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MIND_CONTROL = REGISTRY.register("mind_control", () -> new MindControlMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> HEART_WRENCHING_EFFECT = REGISTRY.register("heart_wrenching_effect", () -> new HeartWrenchingEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DESTRUCTIVE_ENERGY_BURST = REGISTRY.register("destructive_energy_burst", () -> new DestructiveEnergyBurstMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> IMPRISONMENT = REGISTRY.register("imprisonment", () -> new ImprisonmentMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DIMENSION_TEARING_ENERGY_BURST = REGISTRY.register("dimension_tearing_energy_burst", () -> new DimensionTearingEnergyBurstMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BURNING_HEART = REGISTRY.register("burning_heart", () -> new BurningHeartMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MAGICAL_BODY = REGISTRY.register("magical_body", () -> new MagicalBodyMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MAGIC_GHOST = REGISTRY.register("magic_ghost", () -> new MagicGhostMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FLYING = REGISTRY.register("flying", () -> new FlyingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MAGIC_ENERGY = REGISTRY.register("magic_energy", () -> new MagicEnergyMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLESSING = REGISTRY.register("blessing", () -> new BlessingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ABYSSAL_ENERGY_CIRCULATION = REGISTRY.register("abyssal_energy_circulation", () -> new AbyssalEnergyCirculationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> COMBAT_STATE = REGISTRY.register("combat_state", () -> new CombatStateMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ANCIENT_CIRCULATION = REGISTRY.register("ancient_circulation", () -> new AncientCirculationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ORDER_CIRCULATION = REGISTRY.register("order_circulation", () -> new OrderCirculationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INFINITY_CIRCULATION = REGISTRY.register("infinity_circulation", () -> new InfinityCirculationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ORIGIN_CIRCULATION = REGISTRY.register("origin_circulation", () -> new OriginCirculationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DISASTER_QUELLING_CIRCULATION = REGISTRY.register("disaster_quelling_circulation", () -> new DisasterQuellingCirculationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FATE_CIRCULATION = REGISTRY.register("fate_circulation", () -> new FateCirculationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> UNDYING_CIRCULATION = REGISTRY.register("undying_circulation", () -> new UndyingCirculationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ORIGIN_MAGIC_PARTICLE = REGISTRY.register("origin_magic_particle", () -> new OriginMagicParticleMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BACKUP_MAGIC_ENERGY = REGISTRY.register("backup_magic_energy", () -> new BackupMagicEnergyMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SPELL_COOLDOWN = REGISTRY.register("spell_cooldown", () -> new SpellCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> EROSION = REGISTRY.register("erosion", () -> new ErosionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SANITY = REGISTRY.register("sanity", () -> new SanityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CLEAR_COOLDOWN = REGISTRY.register("clear_cooldown", () -> new ClearCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ORDER_SPELL_COOLDOWN = REGISTRY.register("order_spell_cooldown", () -> new OrderSpellCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FROSTBOUND = REGISTRY.register("frostbound", () -> new FrostboundMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLAZEBOUND = REGISTRY.register("blazebound", () -> new BlazeboundMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GALEBOUND = REGISTRY.register("galebound", () -> new GaleboundMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SELECT = REGISTRY.register("select", () -> new SelectMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MagicStoneModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MagicStoneModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(MAGIC_DURATION_TIMER)) {
            MagicDurationTimerEndActionProcedure.execute((LevelAccessor)entity.level(), entity);
        } else if (effectInstance.getEffect().is(MIND_CONTROL)) {
            MindControlEffectEndActionProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(FLYING)) {
            FlyingEffectEndActionProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        }
    }
}

