/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.procedures;

import magic_stone.entity.DreamlandPollenDustEntity;
import magic_stone.init.MagicStoneModEntities;
import magic_stone.init.MagicStoneModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class DreamlandPollenBottleActionProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        ItemStack itemStack;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity _livEnt = (LivingEntity)entity;
            itemStack = _livEnt.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (itemStack.getItem() == MagicStoneModItems.DREAMLAND_POLLEN_BOTTLE.get()) {
            Level _level;
            Entity _shootFrom;
            Level projectileLevel;
            if (entity instanceof LivingEntity) {
                LivingEntity _entity = (LivingEntity)entity;
                _entity.swing(InteractionHand.MAIN_HAND, true);
            }
            if (!(projectileLevel = (_shootFrom = entity).level()).isClientSide()) {
                AbstractArrow _entityToSpawn = DreamlandPollenBottleActionProcedure.initArrowProjectile(new DreamlandPollenDustEntity((EntityType<? extends DreamlandPollenDustEntity>)((EntityType)MagicStoneModEntities.DREAMLAND_POLLEN_DUST.get()), 0.0, 0.0, 0.0, projectileLevel, DreamlandPollenBottleActionProcedure.createArrowWeaponItemStack(projectileLevel, 0, (byte)1)), entity, 0.0f, true, false, false, AbstractArrow.Pickup.DISALLOWED);
                _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
                _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 2.0f, 0.0f);
                projectileLevel.addFreshEntity((Entity)_entityToSpawn);
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:dust_sound")), SoundSource.VOICE, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:dust_sound")), SoundSource.VOICE, 1.0f, 1.0f, false);
                }
            }
            if (entity instanceof Player) {
                Player _player = (Player)entity;
                _player.getCooldowns().addCooldown(itemstack, 10);
            }
            if (DreamlandPollenBottleActionProcedure.getEntityGameType(entity) != GameType.CREATIVE && world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                itemstack.hurtAndBreak(1, (ServerLevel)_level, null, _stkprov -> {});
            }
        } else {
            ItemStack itemStack2;
            if (entity instanceof LivingEntity) {
                LivingEntity _livEnt = (LivingEntity)entity;
                itemStack2 = _livEnt.getOffhandItem();
            } else {
                itemStack2 = ItemStack.EMPTY;
            }
            if (itemStack2.getItem() == MagicStoneModItems.DREAMLAND_POLLEN_BOTTLE.get()) {
                Level _level;
                Entity _shootFrom;
                Level projectileLevel;
                if (entity instanceof LivingEntity) {
                    LivingEntity _entity = (LivingEntity)entity;
                    _entity.swing(InteractionHand.OFF_HAND, true);
                }
                if (!(projectileLevel = (_shootFrom = entity).level()).isClientSide()) {
                    AbstractArrow _entityToSpawn = DreamlandPollenBottleActionProcedure.initArrowProjectile(new DreamlandPollenDustEntity((EntityType<? extends DreamlandPollenDustEntity>)((EntityType)MagicStoneModEntities.DREAMLAND_POLLEN_DUST.get()), 0.0, 0.0, 0.0, projectileLevel, DreamlandPollenBottleActionProcedure.createArrowWeaponItemStack(projectileLevel, 0, (byte)1)), entity, 0.0f, true, false, false, AbstractArrow.Pickup.DISALLOWED);
                    _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
                    _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 2.0f, 0.0f);
                    projectileLevel.addFreshEntity((Entity)_entityToSpawn);
                }
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:dust_sound")), SoundSource.VOICE, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:dust_sound")), SoundSource.VOICE, 1.0f, 1.0f, false);
                    }
                }
                if (entity instanceof Player) {
                    Player _player = (Player)entity;
                    _player.getCooldowns().addCooldown(itemstack, 10);
                }
                if (DreamlandPollenBottleActionProcedure.getEntityGameType(entity) != GameType.CREATIVE && world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    itemstack.hurtAndBreak(1, (ServerLevel)_level, null, _stkprov -> {});
                }
            }
        }
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }

    private static ItemStack createArrowWeaponItemStack(Level level, int knockback, byte piercing) {
        ItemStack weapon = new ItemStack((ItemLike)Items.ARROW);
        if (knockback > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), knockback);
        }
        if (piercing > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (int)piercing);
        }
        return weapon;
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

