/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import magic_stone.entity.MagicParticleEntity;
import magic_stone.entity.StrangeCreatureEntity;
import magic_stone.init.MagicStoneModBlocks;
import magic_stone.init.MagicStoneModEntities;
import magic_stone.procedures.MagicGhostEffectsActionProcedure;
import magic_stone.procedures.MagicGhostSpawnEffectsActionProcedure;
import magic_stone.procedures.MagicGhostTradeActionProcedure;
import magic_stone.procedures.SecondOrderMagicGhostDropsActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class SecondOrderMagicGhostEntity
extends Monster {
    public SecondOrderMagicGhostEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SecondOrderMagicGhostEntity>)((EntityType)MagicStoneModEntities.SECOND_ORDER_MAGIC_GHOST.get()), world);
    }

    public SecondOrderMagicGhostEntity(EntityType<SecondOrderMagicGhostEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 20;
        this.m_21557_(false);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, MagicParticleEntity.class, true, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, StrangeCreatureEntity.class, true, true));
        this.f_21345_.m_25352_(3, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return SecondOrderMagicGhostEntity.this.m_5448_() != null && !SecondOrderMagicGhostEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return SecondOrderMagicGhostEntity.this.m_21566_().m_24995_() && SecondOrderMagicGhostEntity.this.m_5448_() != null && SecondOrderMagicGhostEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = SecondOrderMagicGhostEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                SecondOrderMagicGhostEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 2.0);
            }

            public void m_8037_() {
                LivingEntity livingentity = SecondOrderMagicGhostEntity.this.m_5448_();
                if (SecondOrderMagicGhostEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    SecondOrderMagicGhostEntity.this.m_7327_((Entity)livingentity);
                } else {
                    double d0 = SecondOrderMagicGhostEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.m_20299_(1.0f);
                        SecondOrderMagicGhostEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 2.0);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 20){

            protected Vec3 m_7037_() {
                RandomSource random = SecondOrderMagicGhostEntity.this.m_217043_();
                double dir_x = SecondOrderMagicGhostEntity.this.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_y = SecondOrderMagicGhostEntity.this.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_z = SecondOrderMagicGhostEntity.this.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new RemoveBlockGoal((Block)MagicStoneModBlocks.MAGIC_ORE.get(), (PathfinderMob)this, 1.0, 3));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.villager.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.villager.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.villager.death"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof ThrownPotion || damagesource.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_) || damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        SecondOrderMagicGhostDropsActionProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), source);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        MagicGhostSpawnEffectsActionProcedure.execute((Entity)this);
        return retval;
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        super.m_6071_(sourceentity, hand);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        SecondOrderMagicGhostEntity entity = this;
        Level world = this.m_9236_();
        MagicGhostTradeActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        MagicGhostEffectsActionProcedure.execute((Entity)this);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)MagicStoneModEntities.SECOND_ORDER_MAGIC_GHOST.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 50.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.2);
        builder = builder.m_22268_(Attributes.f_22282_, 0.1);
        builder = builder.m_22268_(Attributes.f_22280_, 0.3);
        return builder;
    }
}

