/*
 * Decompiled with CFR 0.152.
 */
package magicstone.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import magicstone.entity.TheSpearOfAbyssEntity;
import magicstone.init.MagicStoneModEntities;
import magicstone.init.MagicStoneModItems;
import magicstone.procedures.AbyssofMadnessActionProcedure;
import magicstone.procedures.AbyssofMadnessTimerActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class AbyssofMadnessEntity
extends TamableAnimal
implements RangedAttackMob {
    public AbyssofMadnessEntity(EntityType<AbyssofMadnessEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return AbyssofMadnessEntity.this.getTarget() != null && !AbyssofMadnessEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return AbyssofMadnessEntity.this.getMoveControl().hasWanted() && AbyssofMadnessEntity.this.getTarget() != null && AbyssofMadnessEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = AbyssofMadnessEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                AbyssofMadnessEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.5);
            }

            public void tick() {
                LivingEntity livingentity = AbyssofMadnessEntity.this.getTarget();
                if (AbyssofMadnessEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    AbyssofMadnessEntity.this.doHurtTarget(1.getServerLevel((Entity)livingentity), (Entity)livingentity);
                } else {
                    double d0 = AbyssofMadnessEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        AbyssofMadnessEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.5);
                    }
                }
            }
        });
        this.goalSelector.addGoal(4, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 2.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.2, 20){

            protected Vec3 getPosition() {
                RandomSource random = AbyssofMadnessEntity.this.getRandom();
                double dir_x = AbyssofMadnessEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = AbyssofMadnessEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = AbyssofMadnessEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 30, 30.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:cast_magic_spell"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:cast_magic_spell"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof Player) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        AbyssofMadnessTimerActionProcedure.execute((Entity)this);
        return retval;
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.SUCCESS;
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.SUCCESS;
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.SUCCESS;
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        AbyssofMadnessActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        TheSpearOfAbyssEntity.shoot((LivingEntity)this, target);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        AbyssofMadnessEntity retval = (AbyssofMadnessEntity)((EntityType)MagicStoneModEntities.ABYSSOF_MADNESS.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike)((ItemLike)MagicStoneModItems.THEME.get())).test(stack);
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        AbyssofMadnessEntity entity = this;
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.35);
        builder = builder.add(Attributes.MAX_HEALTH, 100.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.5);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 2.0);
        builder = builder.add(Attributes.FLYING_SPEED, 0.35);
        return builder;
    }
}

