/*
 * Decompiled with CFR 0.152.
 */
package magicstone.init;

import magicstone.potion.AbyssErosionMobEffect;
import magicstone.potion.BlazeboundMobEffect;
import magicstone.potion.BlessingMobEffect;
import magicstone.potion.BurningHeartMobEffect;
import magicstone.potion.ClearCooldownMobEffect;
import magicstone.potion.CombatStateMobEffect;
import magicstone.potion.DestructiveEnergyBurstMobEffect;
import magicstone.potion.DimensionTearingEnergyBurstMobEffect;
import magicstone.potion.DisasterQuellingEnergyBurstMobEffect;
import magicstone.potion.ErosionMobEffect;
import magicstone.potion.ErosionResistanceMobEffect;
import magicstone.potion.FallMobEffect;
import magicstone.potion.FrostboundMobEffect;
import magicstone.potion.GaleboundMobEffect;
import magicstone.potion.HeartWrenchingEffectMobEffect;
import magicstone.potion.ImprisonmentMobEffect;
import magicstone.potion.InterferenceMobEffect;
import magicstone.potion.LostMobEffect;
import magicstone.potion.MagicDurationTimerMobEffect;
import magicstone.potion.MindControlMobEffect;
import magicstone.potion.OrderSpellCooldownMobEffect;
import magicstone.potion.OriginMagicParticleMobEffect;
import magicstone.potion.SoulDevourMobEffect;
import magicstone.potion.SoundCooldownMobEffect;
import magicstone.potion.SpaceMendingMobEffect;
import magicstone.potion.SpellCooldownMobEffect;
import magicstone.potion.StarlightGuidanceMobEffect;
import magicstone.procedures.MagicDurationTimerEndActionProcedure;
import magicstone.procedures.MindControlEffectEndActionProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class MagicStoneModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"magic_stone");
    public static final DeferredHolder<MobEffect, MobEffect> MAGIC_DURATION_TIMER = REGISTRY.register("magic_duration_timer", () -> new MagicDurationTimerMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INTERFERENCE = REGISTRY.register("interference", () -> new InterferenceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MIND_CONTROL = REGISTRY.register("mind_control", () -> new MindControlMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> HEART_WRENCHING_EFFECT = REGISTRY.register("heart_wrenching_effect", () -> new HeartWrenchingEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DESTRUCTIVE_ENERGY_BURST = REGISTRY.register("destructive_energy_burst", () -> new DestructiveEnergyBurstMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> IMPRISONMENT = REGISTRY.register("imprisonment", () -> new ImprisonmentMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DIMENSION_TEARING_ENERGY_BURST = REGISTRY.register("dimension_tearing_energy_burst", () -> new DimensionTearingEnergyBurstMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BURNING_HEART = REGISTRY.register("burning_heart", () -> new BurningHeartMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLESSING = REGISTRY.register("blessing", () -> new BlessingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> COMBAT_STATE = REGISTRY.register("combat_state", () -> new CombatStateMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ORIGIN_MAGIC_PARTICLE = REGISTRY.register("origin_magic_particle", () -> new OriginMagicParticleMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SPELL_COOLDOWN = REGISTRY.register("spell_cooldown", () -> new SpellCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> EROSION = REGISTRY.register("erosion", () -> new ErosionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CLEAR_COOLDOWN = REGISTRY.register("clear_cooldown", () -> new ClearCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ORDER_SPELL_COOLDOWN = REGISTRY.register("order_spell_cooldown", () -> new OrderSpellCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FROSTBOUND = REGISTRY.register("frostbound", () -> new FrostboundMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLAZEBOUND = REGISTRY.register("blazebound", () -> new BlazeboundMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GALEBOUND = REGISTRY.register("galebound", () -> new GaleboundMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> EROSION_RESISTANCE = REGISTRY.register("erosion_resistance", () -> new ErosionResistanceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SPACE_MENDING = REGISTRY.register("space_mending", () -> new SpaceMendingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ABYSS_EROSION = REGISTRY.register("abyss_erosion", () -> new AbyssErosionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> STARLIGHT_GUIDANCE = REGISTRY.register("starlight_guidance", () -> new StarlightGuidanceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> LOST = REGISTRY.register("lost", () -> new LostMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FALL = REGISTRY.register("fall", () -> new FallMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DISASTER_QUELLING_ENERGY_BURST = REGISTRY.register("disaster_quelling_energy_burst", () -> new DisasterQuellingEnergyBurstMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SOUND_COOLDOWN = REGISTRY.register("sound_cooldown", () -> new SoundCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SOUL_DEVOUR = REGISTRY.register("soul_devour", () -> new SoulDevourMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MagicStoneModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MagicStoneModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(MAGIC_DURATION_TIMER)) {
            MagicDurationTimerEndActionProcedure.execute((LevelAccessor)entity.level(), entity);
        } else if (effectInstance.getEffect().is(MIND_CONTROL)) {
            MindControlEffectEndActionProcedure.execute(entity);
        }
    }
}

