/*
 * Decompiled with CFR 0.152.
 */
package magicstone.init;

import java.util.Map;
import magicstone.MagicStoneMod;
import magicstone.init.MagicStoneModScreens;
import magicstone.network.MenuStateUpdateMessage;
import magicstone.world.inventory.DummyGuiMenu;
import magicstone.world.inventory.FactionGuiMenu;
import magicstone.world.inventory.GuideGuiMenu;
import magicstone.world.inventory.MagicStoneDebugMenuGuiMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MagicStoneModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"magic_stone");
    public static final RegistryObject<MenuType<GuideGuiMenu>> GUIDE_GUI = REGISTRY.register("guide_gui", () -> IForgeMenuType.create(GuideGuiMenu::new));
    public static final RegistryObject<MenuType<DummyGuiMenu>> DUMMY_GUI = REGISTRY.register("dummy_gui", () -> IForgeMenuType.create(DummyGuiMenu::new));
    public static final RegistryObject<MenuType<FactionGuiMenu>> FACTION_GUI = REGISTRY.register("faction_gui", () -> IForgeMenuType.create(FactionGuiMenu::new));
    public static final RegistryObject<MenuType<MagicStoneDebugMenuGuiMenu>> MAGIC_STONE_DEBUG_MENU_GUI = REGISTRY.register("magic_stone_debug_menu_gui", () -> IForgeMenuType.create(MagicStoneDebugMenuGuiMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MagicStoneMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof MagicStoneModScreens.ScreenAccessor) {
                    MagicStoneModScreens.ScreenAccessor accessor = (MagicStoneModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                MagicStoneMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

