/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import magic_stone.client.model.ModelNew_Abyssal_Energy_Spear;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ItemForTestingItemRenderer
implements NoDataSpecialModelRenderer {
    private static final Map<Integer, Function<EntityModelSet, ItemForTestingItemRenderer>> MODELS = Map.ofEntries(Map.entry(-1, modelSet -> new ItemForTestingItemRenderer((Model)new ModelNew_Abyssal_Energy_Spear(modelSet.bakeLayer(ModelNew_Abyssal_Energy_Spear.LAYER_LOCATION)), ResourceLocation.parse((String)"magic_stone:textures/item/abyssal_spear.png"))));
    private final Model model;
    private final ResourceLocation texture;
    private final ModelResourceLocation transformSource;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemRenderers(RegisterSpecialModelRendererEvent event) {
        event.register(ResourceLocation.parse((String)"magic_stone:item_for_testing"), Unbaked.MAP_CODEC);
    }

    private ItemForTestingItemRenderer(Model model, ResourceLocation texture) {
        this.model = model;
        this.texture = texture;
        this.transformSource = new ModelResourceLocation(ResourceLocation.parse((String)"magic_stone:item/item_for_testing"), "normal");
    }

    public void render(ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean glint) {
        poseStack.pushPose();
        Minecraft.getInstance().getModelManager().getModel(this.transformSource).applyTransform(displayContext, poseStack, ItemForTestingItemRenderer.isLeftHand(displayContext));
        poseStack.translate(0.5, ItemForTestingItemRenderer.isInventory(displayContext) ? 1.5 : 2.0, 0.5);
        poseStack.scale(1.0f, -1.0f, displayContext == ItemDisplayContext.GUI ? -1.0f : 1.0f);
        VertexConsumer vertexConsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferSource, (RenderType)this.model.renderType(this.texture), (boolean)false, (boolean)glint);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    private static boolean isLeftHand(ItemDisplayContext type) {
        return type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || type == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }

    private static boolean isInventory(ItemDisplayContext type) {
        return type == ItemDisplayContext.GUI || type == ItemDisplayContext.FIXED;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(int index) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("index").xmap(opt -> opt.orElse(-1), i -> i == -1 ? Optional.empty() : Optional.of(i)).forGetter(Unbaked::index)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return (SpecialModelRenderer)MODELS.get(this.index).apply(modelSet);
        }
    }
}

