/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.entity;

import magic_stone.entity.ApprenticeOfTheSorcererEntity;
import magic_stone.entity.DreamlandGuardiansEntity;
import magic_stone.entity.MagicalConstructGiantEntity;
import magic_stone.entity.MasterOfMagicEntity;
import magic_stone.entity.MengLiEntity;
import magic_stone.entity.SlaveEntity;
import magic_stone.entity.StrangeCreatureEntity;
import magic_stone.init.MagicStoneModItems;
import magic_stone.procedures.AbyssalRemnantWarriorActionProcedure;
import magic_stone.procedures.AbyssalRemnantWarriorDropsActionProcedure;
import magic_stone.procedures.AbyssalRemnantWarriorHurtActionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class AbyssalRemnantWarriorEntity
extends Monster {
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public AbyssalRemnantWarriorEntity(EntityType<AbyssalRemnantWarriorEntity> type, Level world) {
        super(type, world);
        this.xpReward = 500;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)MagicStoneModItems.ABYSSAL_ENERGY_SPEAR.get()));
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new LeapAtTargetGoal((Mob)this, 0.75f));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 2.0, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, StrangeCreatureEntity.class, false, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, SlaveEntity.class, false, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, ApprenticeOfTheSorcererEntity.class, false, false));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, MasterOfMagicEntity.class, false, false));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, false));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false, false));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, MagicalConstructGiantEntity.class, false, false));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, DreamlandGuardiansEntity.class, false, false));
        this.targetSelector.addGoal(13, (Goal)new NearestAttackableTargetGoal((Mob)this, MengLiEntity.class, false, false));
        this.goalSelector.addGoal(14, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(15, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(16, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:boss"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"magic_stone:stranger_dead"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        AbyssalRemnantWarriorEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        AbyssalRemnantWarriorHurtActionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        AbyssalRemnantWarriorDropsActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void baseTick() {
        super.baseTick();
        AbyssalRemnantWarriorActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep(ServerLevel serverLevel) {
        super.customServerAiStep(serverLevel);
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 1000.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 500.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 48.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 2.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 100.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        return builder;
    }
}

