/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.fluid;

import magic_stone.init.MagicStoneModBlocks;
import magic_stone.init.MagicStoneModFluidTypes;
import magic_stone.init.MagicStoneModFluids;
import magic_stone.init.MagicStoneModItems;
import magic_stone.init.MagicStoneModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class DreamlandWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)MagicStoneModFluidTypes.DREAMLAND_WATER_TYPE.get(), () -> (Fluid)MagicStoneModFluids.DREAMLAND_WATER.get(), () -> (Fluid)MagicStoneModFluids.FLOWING_DREAMLAND_WATER.get()).explosionResistance(1000.0f).tickRate(2).levelDecreasePerBlock(2).slopeFindDistance(2).bucket(() -> (Item)MagicStoneModItems.DREAMLAND_WATER_BUCKET.get()).block(() -> (LiquidBlock)MagicStoneModBlocks.DREAMLAND_WATER.get());

    private DreamlandWaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return (SimpleParticleType)MagicStoneModParticleTypes.DREAMLAND_FLOWERS.get();
    }

    public static class Flowing
    extends DreamlandWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends DreamlandWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

