/*
 * Decompiled with CFR 0.152.
 */
package magic_stone.init;

import magic_stone.potion.AbyssErosionMobEffect;
import magic_stone.potion.BlazeboundMobEffect;
import magic_stone.potion.BlessingMobEffect;
import magic_stone.potion.BurningHeartMobEffect;
import magic_stone.potion.ClearCooldownMobEffect;
import magic_stone.potion.CombatStateMobEffect;
import magic_stone.potion.DestructiveEnergyBurstMobEffect;
import magic_stone.potion.DimensionTearingEnergyBurstMobEffect;
import magic_stone.potion.ErosionMobEffect;
import magic_stone.potion.ErosionResistanceMobEffect;
import magic_stone.potion.FallMobEffect;
import magic_stone.potion.FrostboundMobEffect;
import magic_stone.potion.GaleboundMobEffect;
import magic_stone.potion.HeartWrenchingEffectMobEffect;
import magic_stone.potion.ImprisonmentMobEffect;
import magic_stone.potion.InterferenceMobEffect;
import magic_stone.potion.LostMobEffect;
import magic_stone.potion.MagicDurationTimerMobEffect;
import magic_stone.potion.MindControlMobEffect;
import magic_stone.potion.OrderSpellCooldownMobEffect;
import magic_stone.potion.OriginMagicParticleMobEffect;
import magic_stone.potion.SpaceMendingMobEffect;
import magic_stone.potion.SpellCooldownMobEffect;
import magic_stone.potion.StarlightGuidanceMobEffect;
import magic_stone.procedures.MagicDurationTimerEndActionProcedure;
import magic_stone.procedures.MindControlEffectEndActionProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class MagicStoneModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"magic_stone");
    public static final DeferredHolder<MobEffect, MobEffect> MAGIC_DURATION_TIMER = REGISTRY.register("magic_duration_timer", () -> new MagicDurationTimerMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INTERFERENCE = REGISTRY.register("interference", () -> new InterferenceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MIND_CONTROL = REGISTRY.register("mind_control", () -> new MindControlMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> HEART_WRENCHING_EFFECT = REGISTRY.register("heart_wrenching_effect", () -> new HeartWrenchingEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DESTRUCTIVE_ENERGY_BURST = REGISTRY.register("destructive_energy_burst", () -> new DestructiveEnergyBurstMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> IMPRISONMENT = REGISTRY.register("imprisonment", () -> new ImprisonmentMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DIMENSION_TEARING_ENERGY_BURST = REGISTRY.register("dimension_tearing_energy_burst", () -> new DimensionTearingEnergyBurstMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BURNING_HEART = REGISTRY.register("burning_heart", () -> new BurningHeartMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLESSING = REGISTRY.register("blessing", () -> new BlessingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> COMBAT_STATE = REGISTRY.register("combat_state", () -> new CombatStateMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ORIGIN_MAGIC_PARTICLE = REGISTRY.register("origin_magic_particle", () -> new OriginMagicParticleMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SPELL_COOLDOWN = REGISTRY.register("spell_cooldown", () -> new SpellCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> EROSION = REGISTRY.register("erosion", () -> new ErosionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CLEAR_COOLDOWN = REGISTRY.register("clear_cooldown", () -> new ClearCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ORDER_SPELL_COOLDOWN = REGISTRY.register("order_spell_cooldown", () -> new OrderSpellCooldownMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FROSTBOUND = REGISTRY.register("frostbound", () -> new FrostboundMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLAZEBOUND = REGISTRY.register("blazebound", () -> new BlazeboundMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GALEBOUND = REGISTRY.register("galebound", () -> new GaleboundMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> EROSION_RESISTANCE = REGISTRY.register("erosion_resistance", () -> new ErosionResistanceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SPACE_MENDING = REGISTRY.register("space_mending", () -> new SpaceMendingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ABYSS_EROSION = REGISTRY.register("abyss_erosion", () -> new AbyssErosionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> STARLIGHT_GUIDANCE = REGISTRY.register("starlight_guidance", () -> new StarlightGuidanceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> LOST = REGISTRY.register("lost", () -> new LostMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FALL = REGISTRY.register("fall", () -> new FallMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MagicStoneModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MagicStoneModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(MAGIC_DURATION_TIMER)) {
            MagicDurationTimerEndActionProcedure.execute((LevelAccessor)entity.level(), entity);
        } else if (effectInstance.getEffect().is(MIND_CONTROL)) {
            MindControlEffectEndActionProcedure.execute(entity);
        }
    }
}

