/*
 * Decompiled with CFR 0.152.
 */
package magicstone.entity;

import javax.annotation.Nullable;
import magicstone.init.MagicStoneModEntities;
import magicstone.init.MagicStoneModItems;
import magicstone.procedures.TheSpearOfAbyssHitActionProcedure;
import magicstone.procedures.TheSpearOfAbyssParticleActionProcedure;
import magicstone.procedures.TheSpearOfAbyssParticleHitActionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class TheSpearOfAbyssEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)MagicStoneModItems.ABYSSAL_ENERGY_SPEAR.get());
    private int knockback = 0;

    public TheSpearOfAbyssEntity(EntityType<? extends TheSpearOfAbyssEntity> type, Level world) {
        super(type, world);
        this.setNoGravity(true);
    }

    public TheSpearOfAbyssEntity(EntityType<? extends TheSpearOfAbyssEntity> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, world, PROJECTILE_ITEM, firedFromWeapon);
        this.setNoGravity(true);
        if (firedFromWeapon != null) {
            this.setKnockback(EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), (ItemStack)firedFromWeapon));
        }
    }

    public TheSpearOfAbyssEntity(EntityType<? extends TheSpearOfAbyssEntity> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, entity, world, PROJECTILE_ITEM, firedFromWeapon);
        this.setNoGravity(true);
        if (firedFromWeapon != null) {
            this.setKnockback(EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), (ItemStack)firedFromWeapon));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)MagicStoneModItems.ABYSSAL_ENERGY_SPEAR.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if ((double)this.knockback > 0.0) {
            double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        } else {
            super.doKnockback(livingEntity, damageSource);
        }
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 projectilePosition, Vec3 deltaPosition) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        AABB lookupBox = this.getBoundingBox();
        for (Entity entity1 : this.level().getEntities((Entity)this, lookupBox, x$0 -> this.canHitEntity((Entity)x$0))) {
            double d1;
            AABB aabb;
            if (entity1 == this.getOwner() || !(aabb = entity1.getBoundingBox()).intersects(lookupBox) || !((d1 = projectilePosition.distanceToSqr(projectilePosition)) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }

    private Direction determineHitDirection(AABB entityBox, AABB blockBox) {
        double dx = entityBox.getCenter().x - blockBox.getCenter().x;
        double dy = entityBox.getCenter().y - blockBox.getCenter().y;
        double dz = entityBox.getCenter().z - blockBox.getCenter().z;
        double absDx = Math.abs(dx);
        double absDy = Math.abs(dy);
        double absDz = Math.abs(dz);
        if (absDy > absDx && absDy > absDz) {
            return dy > 0.0 ? Direction.DOWN : Direction.UP;
        }
        if (absDx > absDz) {
            return dx > 0.0 ? Direction.WEST : Direction.EAST;
        }
        return dz > 0.0 ? Direction.NORTH : Direction.SOUTH;
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        TheSpearOfAbyssHitActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        TheSpearOfAbyssParticleHitActionProcedure.execute((LevelAccessor)this.level(), blockHitResult.getBlockPos().getX(), blockHitResult.getBlockPos().getY(), blockHitResult.getBlockPos().getZ());
    }

    public void tick() {
        super.tick();
        if (!this.isNoPhysics()) {
            for (VoxelShape collision : this.level().getBlockCollisions((Entity)this, this.getBoundingBox())) {
                for (AABB blockAABB : collision.toAabbs()) {
                    if (!this.getBoundingBox().intersects(blockAABB)) continue;
                    BlockPos blockPos = new BlockPos((int)blockAABB.minX, (int)blockAABB.minY, (int)blockAABB.minZ);
                    Vec3 intersectionPoint = new Vec3((blockAABB.minX + blockAABB.maxX) / 2.0, (blockAABB.minY + blockAABB.maxY) / 2.0, (blockAABB.minZ + blockAABB.maxZ) / 2.0);
                    Direction hitDirection = this.determineHitDirection(this.getBoundingBox(), blockAABB);
                    this.hitTargetOrDeflectSelf((HitResult)new BlockHitResult(intersectionPoint, hitDirection, blockPos, false));
                }
            }
        }
        TheSpearOfAbyssParticleActionProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        if (this.inGround) {
            this.discard();
        }
    }

    public static TheSpearOfAbyssEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return TheSpearOfAbyssEntity.shoot(world, entity, source, 1.0f, 100.0, 2);
    }

    public static TheSpearOfAbyssEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return TheSpearOfAbyssEntity.shoot(world, entity, source, pullingPower * 1.0f, 100.0, 2);
    }

    public static TheSpearOfAbyssEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        TheSpearOfAbyssEntity entityarrow = new TheSpearOfAbyssEntity((EntityType<? extends TheSpearOfAbyssEntity>)((EntityType)MagicStoneModEntities.THE_SPEAR_OF_ABYSS.get()), entity, world, null);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.trident.throw")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static TheSpearOfAbyssEntity shoot(LivingEntity entity, LivingEntity target) {
        TheSpearOfAbyssEntity entityarrow = new TheSpearOfAbyssEntity((EntityType<? extends TheSpearOfAbyssEntity>)((EntityType)MagicStoneModEntities.THE_SPEAR_OF_ABYSS.get()), entity, entity.level(), null);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(100.0);
        entityarrow.setKnockback(2);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.trident.throw")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

