#version 120

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;
attribute vec4 at_tangent;

uniform mat4 gbufferModelView;
uniform mat4 gbufferProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjectionInverse;

uniform vec3 cameraPosition;
uniform float frameTimeCounter;
uniform int worldTime;

varying vec2 texcoord;
varying vec2 lmcoord;
varying vec4 glcolor;
varying vec3 normal;
varying vec3 worldPos;
varying vec3 viewPos;
varying float blockId;

varying float waveEffect;

// Jitter reduction function
vec4 jitterReduction(vec4 position) {
    vec4 correctedPos = gbufferProjection * gbufferModelView * position;
    correctedPos.xyz = correctedPos.xyz / correctedPos.w;
    correctedPos.xy = floor(correctedPos.xy * 60.0) / 60.0;
    correctedPos.xyz *= correctedPos.w;
    return correctedPos;
}

void main() {
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    glcolor = gl_Color;
    normal = normalize(gl_NormalMatrix * gl_Normal);
    
    vec4 position = gl_Vertex;
    worldPos = (gbufferModelViewInverse * gbufferModelView * position).xyz *-1;
    viewPos = (gbufferModelView * position).xyz;
    
    blockId = mc_Entity.x;

    gl_Position = jitterReduction(position);
}