/*
 * Decompiled with CFR 0.152.
 */
package realisticstamina.rstamina.networking.packet;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import realisticstamina.rstamina.RStaminaMod;
import realisticstamina.rstamina.RStaminaPlayerState;
import realisticstamina.rstamina.ServerState;
import realisticstamina.rstamina.networking.NetworkingPackets;

public class UpdateStaminaC2SPacket {
    public static void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        ServerState serverState = ServerState.getServerState(server);
        RStaminaPlayerState playerstate = ServerState.getPlayerState((class_1309)player);
        playerstate.staminaLossRate = RStaminaMod.config.staminaLossRate;
        playerstate.staminaGainRate = RStaminaMod.config.staminaGainRate;
        playerstate.energyLossRate = RStaminaMod.config.energyLossRate;
        playerstate.energyGainRate = RStaminaMod.config.restingEnergyGainTick;
        playerstate.walkingStaminaLossRate = RStaminaMod.config.walkingStaminaLossRate;
        playerstate.walkingEnergyLossRate = RStaminaMod.config.walkingEnergyLossRate;
        if (playerstate.staminaRegenCooldown > 0) {
            --playerstate.staminaRegenCooldown;
        }
        if (playerstate.miningFatigueCooldown > 0) {
            --playerstate.miningFatigueCooldown;
        }
        if (playerstate.isExhausted) {
            boolean isResting;
            boolean bl = isResting = !player.method_5624() && !player.method_5681() && !player.method_6101() && player.method_24828();
            if (isResting) {
                --playerstate.exhaustionRestTimer;
                if (playerstate.exhaustionRestTimer <= 0) {
                    playerstate.isExhausted = false;
                    if (RStaminaMod.config.showExhaustionWarning) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a\u2713 You've recovered from exhaustion."), true);
                    }
                }
            } else {
                playerstate.exhaustionRestTimer = RStaminaMod.config.exhaustionRecoveryTicks;
            }
        }
        boolean isLowStamina = playerstate.stamina <= RStaminaMod.config.exhaustionThreshold;
        boolean performedStaminaAction = false;
        boolean energyUpdated = false;
        Runnable updateEnergy = () -> {
            if (RStaminaMod.config.enableEnergySystem) {
                playerstate.updateMaxStamina();
            }
        };
        if (playerstate.lastX == 0.0 && playerstate.lastZ == 0.0) {
            playerstate.lastX = player.method_23317();
            playerstate.lastZ = player.method_23321();
        }
        if (playerstate.wasOnGround && !player.method_24828() && !player.method_5799() && !player.method_7337() && !player.method_7325() && player.method_18798().field_1351 > 0.0) {
            if (playerstate.isExhausted) {
                player.method_18800(player.method_18798().field_1352, 0.0, player.method_18798().field_1350);
                player.field_6037 = true;
            } else {
                performedStaminaAction = true;
                playerstate.stamina -= RStaminaMod.config.jumpStaminaCost;
                if (RStaminaMod.config.enableEnergySystem) {
                    playerstate.energy -= 0.03;
                    playerstate.usedEnergy += 0.03;
                    energyUpdated = true;
                }
                playerstate.staminaRegenCooldown = 20;
                serverState.method_80();
            }
        }
        playerstate.wasOnGround = player.method_24828();
        if (player.method_5624() && !player.method_7337() && !player.method_7325()) {
            performedStaminaAction = true;
            playerstate.stamina -= playerstate.staminaLossRate;
            if (RStaminaMod.config.enableEnergySystem) {
                double energyDrainRate = playerstate.energyLossRate;
                if (RStaminaMod.config.speedBasedEnergyDrain) {
                    double velocityX = player.method_18798().field_1352;
                    double velocityZ = player.method_18798().field_1350;
                    double velocityMagnitude = Math.sqrt(velocityX * velocityX + velocityZ * velocityZ);
                    double speedMultiplier = UpdateStaminaC2SPacket.calculateSpeedEnergyDrainMultiplier(player, playerstate, velocityMagnitude);
                    energyDrainRate *= speedMultiplier;
                }
                playerstate.energy -= energyDrainRate;
                playerstate.usedEnergy += energyDrainRate;
                energyUpdated = true;
            }
            serverState.method_80();
        } else if (!(player.method_5624() || player.method_5681() || player.method_6101())) {
            double dz;
            double dx = player.method_23317() - playerstate.lastX;
            double horizontalDistance = Math.sqrt(dx * dx + (dz = player.method_23321() - playerstate.lastZ) * dz);
            boolean isMoving = horizontalDistance > 0.0015;
            boolean bl = playerstate.wasWalking = isMoving && player.method_24828() && !player.method_5624() && !player.method_5681() && !player.method_6101() && !player.method_5765();
            if (playerstate.wasWalking && RStaminaMod.config.enableWalkingStaminaDrain && !player.method_7337() && !player.method_7325()) {
                performedStaminaAction = true;
                playerstate.staminaRegenCooldown = 10;
                playerstate.stamina -= playerstate.walkingStaminaLossRate;
                if (RStaminaMod.config.enableEnergySystem) {
                    double energyDrainRate = playerstate.walkingEnergyLossRate;
                    if (RStaminaMod.config.speedBasedEnergyDrain) {
                        double speedMultiplier = UpdateStaminaC2SPacket.calculateSpeedEnergyDrainMultiplier(player, playerstate, horizontalDistance);
                        energyDrainRate *= speedMultiplier;
                    }
                    playerstate.energy -= energyDrainRate;
                    playerstate.usedEnergy += energyDrainRate;
                    energyUpdated = true;
                }
                serverState.method_80();
            }
            if (playerstate.staminaRegenCooldown <= 0 && !playerstate.isExhausted && playerstate.stamina < playerstate.maxStamina && (!playerstate.wasWalking || playerstate.wasWalking && RStaminaMod.config.enableWalkingStaminaRegen && !RStaminaMod.config.enableWalkingStaminaDrain)) {
                double regenerationRate = playerstate.staminaGainRate;
                if (playerstate.wasWalking && RStaminaMod.config.enableWalkingStaminaRegen) {
                    double walkingMultiplier = Math.max(1.0, RStaminaMod.config.walkingStaminaRegenMultiplier);
                    regenerationRate /= walkingMultiplier;
                }
                if (player.method_5715() && !playerstate.wasWalking) {
                    regenerationRate = 0.21875;
                }
                playerstate.stamina += regenerationRate;
                if (playerstate.stamina > playerstate.maxStamina) {
                    playerstate.stamina = playerstate.maxStamina;
                }
                serverState.method_80();
            }
        }
        if (energyUpdated) {
            updateEnergy.run();
        }
        if (isLowStamina && performedStaminaAction && !playerstate.isExhausted) {
            playerstate.isExhausted = true;
            playerstate.exhaustionRestTimer = RStaminaMod.config.exhaustionRecoveryTicks;
            if (RStaminaMod.config.showExhaustionWarning) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u26a0 You're exhausted! Rest for a moment to recover."), true);
            }
        }
        UpdateStaminaC2SPacket.applyStatusEffects(player, playerstate);
        if (playerstate.stamina > playerstate.maxStamina) {
            playerstate.stamina = playerstate.maxStamina;
        } else if (playerstate.stamina < 0.0) {
            playerstate.stamina = 0.0;
        }
        UpdateStaminaC2SPacket.updateSpeedMultiplier(player, playerstate);
        UpdateStaminaC2SPacket.sendStateToClient(player, playerstate);
        playerstate.lastX = player.method_23317();
        playerstate.lastZ = player.method_23321();
    }

    private static void applyStatusEffects(class_3222 player, RStaminaPlayerState playerstate) {
        if (playerstate.stamina <= 0.0) {
            player.method_6092(new class_1293(class_1294.field_5909, 80, 5, true, false));
            player.method_6092(new class_1293(class_1294.field_5901, 80, 2, true, false));
            player.method_6092(new class_1293(class_1294.field_5911, 80, 2, true, false));
            player.method_6092(new class_1293(class_1294.field_5916, 80, 0, true, false));
            playerstate.miningFatigueCooldown = RStaminaMod.config.miningFatigueCooldownTicks;
        } else if (playerstate.stamina <= 5.0) {
            player.method_6092(new class_1293(class_1294.field_5909, 60, 4, true, false));
            player.method_6092(new class_1293(class_1294.field_5901, 60, 2, true, false));
            player.method_6092(new class_1293(class_1294.field_5911, 60, 1, true, false));
            playerstate.miningFatigueCooldown = RStaminaMod.config.miningFatigueCooldownTicks;
        } else if (playerstate.stamina <= 12.0) {
            player.method_6092(new class_1293(class_1294.field_5909, 40, 4, true, false));
            player.method_6092(new class_1293(class_1294.field_5901, 40, 0, true, false));
        } else if (playerstate.stamina <= 24.0) {
            player.method_6092(new class_1293(class_1294.field_5909, 20, 1, true, false));
        } else if (playerstate.stamina > 5.0 && playerstate.miningFatigueCooldown > 0) {
            player.method_6092(new class_1293(class_1294.field_5901, 20, 1, true, false));
            player.method_6092(new class_1293(class_1294.field_5909, 20, 1, true, false));
        }
    }

    private static void updateSpeedMultiplier(class_3222 player, RStaminaPlayerState playerstate) {
        if (RStaminaMod.config.enableSpeedMultiplier) {
            double baseStamina = RStaminaMod.config.totalStamina;
            double maxStamina = RStaminaMod.config.fitnessStaminaLimit;
            double currentTotalStamina = playerstate.getTotalStamina();
            double staminaProgress = Math.min(1.0, Math.max(0.0, (currentTotalStamina - baseStamina) / (maxStamina - baseStamina)));
            double speedMultiplier = 1.0 + staminaProgress * (RStaminaMod.config.maxSpeedMultiplier - 1.0);
            if (Math.abs(playerstate.speedMultiplier - speedMultiplier) > 0.01) {
                playerstate.speedMultiplier = speedMultiplier;
                if (speedMultiplier > 1.01) {
                    player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7bSpeed multiplier: \u00a7f%.2fx", speedMultiplier)), true);
                }
            }
        }
    }

    private static void sendStateToClient(class_3222 player, RStaminaPlayerState playerstate) {
        class_2540 sendingdata = PacketByteBufs.create();
        sendingdata.writeDouble(playerstate.stamina);
        sendingdata.writeDouble(playerstate.maxStamina);
        sendingdata.writeDouble(playerstate.energy);
        sendingdata.writeDouble(playerstate.totalStamina);
        sendingdata.writeDouble(playerstate.speedMultiplier);
        ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkingPackets.SEND_PLAYERSTATE_S2C_PACKET_ID, (class_2540)sendingdata);
    }

    private static double calculateSpeedEnergyDrainMultiplier(class_3222 player, RStaminaPlayerState playerstate, double velocityMagnitude) {
        double multiplier = 1.0;
        if (RStaminaMod.config.speedBasedEnergyDrain) {
            double normalizedVelocity;
            if (RStaminaMod.config.enableSpeedMultiplier && playerstate.speedMultiplier > 1.0) {
                double speedFactor = Math.pow(playerstate.speedMultiplier, RStaminaMod.config.speedMultiplierEnergyDrainFactor);
                multiplier *= speedFactor;
            }
            if ((normalizedVelocity = Math.min(1.0, velocityMagnitude * 5.0)) > 0.1) {
                double velocityFactor = 1.0 + (normalizedVelocity - 0.1) * 10.0 * ((RStaminaMod.config.maxSpeedEnergyDrainMultiplier - 1.0) / 0.9);
                velocityFactor = Math.min(velocityFactor, RStaminaMod.config.maxSpeedEnergyDrainMultiplier);
                multiplier *= velocityFactor;
            }
        }
        return multiplier;
    }
}

