/*
 * Decompiled with CFR 0.152.
 */
package realisticstamina.rstamina;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import java.util.function.BiConsumer;
import me.lortseam.completeconfig.data.ConfigOptions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import realisticstamina.rstamina.RStaminaConfig;
import realisticstamina.rstamina.RStaminaPlayerState;
import realisticstamina.rstamina.ServerState;
import realisticstamina.rstamina.item.EnergyDrinkItem;
import realisticstamina.rstamina.item.TestItem;
import realisticstamina.rstamina.networking.NetworkingPackets;

public class RStaminaMod
implements ModInitializer {
    public static final String rStaminaModVersion = "1.5.2";
    public static final String modid = "rstamina";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rstamina");
    public static final RStaminaConfig config = new RStaminaConfig();
    public static final TestItem TEST_ITEM = new TestItem((class_1792.class_1793)new FabricItemSettings());
    public static final EnergyDrinkItem ENERGY_DRINK_ITEM = new EnergyDrinkItem((class_1792.class_1793)new FabricItemSettings().maxCount(16));

    private static void snapshotDefaultsFromConfig() {
        Defaults.staminaGainRate = RStaminaMod.config.staminaGainRate;
        Defaults.staminaLossRate = RStaminaMod.config.staminaLossRate;
        Defaults.jumpStaminaCost = RStaminaMod.config.jumpStaminaCost;
        Defaults.enableWalkingStaminaDrain = RStaminaMod.config.enableWalkingStaminaDrain;
        Defaults.walkingStaminaLossRate = RStaminaMod.config.walkingStaminaLossRate;
        Defaults.enableWalkingStaminaRegen = RStaminaMod.config.enableWalkingStaminaRegen;
        Defaults.walkingStaminaRegenMultiplier = RStaminaMod.config.walkingStaminaRegenMultiplier;
        Defaults.enableEnergySystem = RStaminaMod.config.enableEnergySystem;
        Defaults.speedBasedEnergyDrain = RStaminaMod.config.speedBasedEnergyDrain;
        Defaults.energyLossRate = RStaminaMod.config.energyLossRate;
        Defaults.walkingEnergyLossRate = RStaminaMod.config.walkingEnergyLossRate;
        Defaults.exhaustionThreshold = RStaminaMod.config.exhaustionThreshold;
        Defaults.exhaustionRecoveryTicks = RStaminaMod.config.exhaustionRecoveryTicks;
        Defaults.showExhaustionWarning = RStaminaMod.config.showExhaustionWarning;
        Defaults.enableSpeedMultiplier = RStaminaMod.config.enableSpeedMultiplier;
        Defaults.maxSpeedMultiplier = RStaminaMod.config.maxSpeedMultiplier;
    }

    public void onInitialize() {
        RStaminaMod.snapshotDefaultsFromConfig();
        config.load();
        ConfigOptions.mod((String)modid).branch(new String[]{"branch", "config"});
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(modid, "test_item"), (Object)((Object)TEST_ITEM));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(modid, "energy_drink"), (Object)((Object)ENERGY_DRINK_ITEM));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41061).register(content -> content.method_45421((class_1935)ENERGY_DRINK_ITEM));
        NetworkingPackets.registerC2SPackets();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            ServerState serverState = ServerState.getServerState(handler.field_14140.method_37908().method_8503());
            RStaminaPlayerState playerState = ServerState.getPlayerState((class_1309)handler.field_14140);
            if (!Objects.equals(serverState.worldVersion, rStaminaModVersion)) {
                serverState.worldVersion = rStaminaModVersion;
                serverState.method_80();
            }
            if (!playerState.edited) {
                RStaminaMod.syncPlayerStateWithConfig(playerState);
                playerState.updateMaxStamina();
                playerState.staminaRegenCooldown = 0;
                serverState.method_80();
            }
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, blockPos, state, be) -> {
            ServerState serverState = ServerState.getServerState(player.method_37908().method_8503());
            RStaminaPlayerState playerState = ServerState.getPlayerState((class_1309)player);
            class_1799 mainStack = player.method_6047();
            boolean hasEfficiency = false;
            for (int i = 0; i < mainStack.method_7921().size(); ++i) {
                if (!Objects.equals(mainStack.method_7921().method_10602(i).method_10558("id"), "minecraft:efficiency")) continue;
                hasEfficiency = true;
                break;
            }
            if (!player.method_7337() && !hasEfficiency && RStaminaMod.config.breakingBlocksUsesStamina && world.method_8320(blockPos).method_51367()) {
                playerState.stamina -= RStaminaMod.config.blockBreakStaminaCost;
                if (RStaminaMod.config.enableEnergySystem) {
                    playerState.energy -= 0.03;
                    playerState.usedEnergy += 0.03;
                    playerState.updateMaxStamina();
                }
                playerState.staminaRegenCooldown = 20;
                serverState.method_80();
            }
            return true;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (RStaminaMod.config.enableMiningStaminaGain && !player.method_7337() && !player.method_7325() && !world.method_8608()) {
                ServerState serverState = ServerState.getServerState(player.method_5682());
                RStaminaPlayerState playerState = ServerState.getPlayerState((class_1309)player);
                ++playerState.miningBlockProgress;
                if (playerState.miningBlockProgress >= RStaminaMod.config.miningBlocksPerStaminaGain) {
                    playerState.miningBonusStamina += RStaminaMod.config.miningStaminaGainAmount;
                    playerState.miningBlockProgress = 0;
                    playerState.updateMaxStamina();
                    serverState.method_80();
                }
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setTotalStamina").requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            ServerState serverState = ServerState.getServerState(class_2186.method_9315((CommandContext)context, (String)"player").method_37908().method_8503());
            RStaminaPlayerState playerState = ServerState.getPlayerState((class_1309)class_2186.method_9315((CommandContext)context, (String)"player"));
            double newValue = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            playerState.setCustomTotalStamina(newValue);
            playerState.stamina = playerState.maxStamina = playerState.totalStamina * (playerState.energy / 100.0);
            serverState.method_80();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Set " + class_2186.method_9315((CommandContext)context, (String)"player").method_5477().getString() + "'s total stamina to " + newValue)));
            return 1;
        })))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resetStaminaStats").requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            ServerState serverState = ServerState.getServerState(class_2186.method_9315((CommandContext)context, (String)"player").method_37908().method_8503());
            RStaminaPlayerState playerState = ServerState.getPlayerState((class_1309)class_2186.method_9315((CommandContext)context, (String)"player"));
            playerState.resetToConfigDefaults();
            playerState.stamina = RStaminaMod.config.totalStamina;
            playerState.gainedStamina = 0.0;
            playerState.miningBonusStamina = 0.0;
            playerState.miningBlockProgress = 0;
            playerState.energy = 100.0;
            playerState.usedEnergy = 0.0;
            playerState.staminaRegenCooldown = 0;
            playerState.updateMaxStamina();
            RStaminaMod.syncPlayerStateWithConfig(playerState);
            serverState.method_80();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Reset " + class_2186.method_9315((CommandContext)context, (String)"player").method_5477().getString() + "'s stamina stats.")));
            return 1;
        }))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            RStaminaMod.registerPlayerStateDoubleSetterCommand((CommandDispatcher<class_2168>)dispatcher, "setStaminaLossRate", "stamina loss rate", (ps, val) -> {
                ps.staminaLossRate = val;
            });
            RStaminaMod.registerPlayerStateDoubleSetterCommand((CommandDispatcher<class_2168>)dispatcher, "setStaminaGainRate", "stamina gain rate", (ps, val) -> {
                ps.staminaGainRate = val;
            });
            RStaminaMod.registerPlayerStateDoubleSetterCommand((CommandDispatcher<class_2168>)dispatcher, "setEnergyLossRate", "energy loss rate", (ps, val) -> {
                ps.energyLossRate = val;
            });
            RStaminaMod.registerPlayerStateDoubleSetterCommand((CommandDispatcher<class_2168>)dispatcher, "setEnergyGainRate", "energy gain rate", (ps, val) -> {
                ps.energyGainRate = val;
            });
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"showspeed").executes(context -> {
                class_3222 player = ((class_2168)context.getSource()).method_44023();
                if (player != null) {
                    if (RStaminaMod.config.enableSpeedMultiplier) {
                        RStaminaPlayerState playerState = ServerState.getPlayerState((class_1309)player);
                        double baseStamina = RStaminaMod.config.totalStamina;
                        double maxStamina = RStaminaMod.config.fitnessStaminaLimit;
                        double currentTotalStamina = playerState.totalStamina;
                        double staminaProgress = Math.min(1.0, Math.max(0.0, (currentTotalStamina - baseStamina) / (maxStamina - baseStamina)));
                        double speedMultiplier = 1.0 + staminaProgress * (RStaminaMod.config.maxSpeedMultiplier - 1.0);
                        player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7bCurrent speed multiplier: \u00a7f%.2fx", speedMultiplier)), false);
                        class_2540 sendingData = PacketByteBufs.create();
                        sendingData.writeInt(600);
                        ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkingPackets.SEND_SHOW_SPEED_S2C_PACKET_ID, (class_2540)sendingData);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cSpeed multiplier feature is disabled in the configuration."), false);
                    }
                }
                return 1;
            }));
        });
    }

    private static void registerPlayerStateDoubleSetterCommand(CommandDispatcher<class_2168> dispatcher, String commandName, String statDescription, BiConsumer<RStaminaPlayerState, Double> valueSetter) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 targetedPlayer = class_2186.method_9315((CommandContext)context, (String)"player");
            ServerState serverState = ServerState.getServerState(targetedPlayer.method_37908().method_8503());
            RStaminaPlayerState playerState = ServerState.getPlayerState((class_1309)targetedPlayer);
            double commandValue = DoubleArgumentType.getDouble((CommandContext)context, (String)"value");
            valueSetter.accept(playerState, commandValue);
            playerState.edited = true;
            serverState.method_80();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Set " + targetedPlayer.method_5477().getString() + "'s " + statDescription + " to " + commandValue)));
            return 1;
        }))));
    }

    private static void syncPlayerStateWithConfig(RStaminaPlayerState playerState) {
        playerState.energyGainRate = RStaminaMod.config.restingEnergyGainTick;
        playerState.energyLossRate = RStaminaMod.config.energyLossRate;
        playerState.staminaLossRate = RStaminaMod.config.staminaLossRate;
        playerState.staminaGainRate = RStaminaMod.config.staminaGainRate;
        playerState.walkingStaminaLossRate = RStaminaMod.config.walkingStaminaLossRate;
        playerState.walkingEnergyLossRate = RStaminaMod.config.walkingEnergyLossRate;
    }

    public static final class Defaults {
        public static double staminaGainRate;
        public static double staminaLossRate;
        public static double jumpStaminaCost;
        public static boolean enableWalkingStaminaDrain;
        public static double walkingStaminaLossRate;
        public static boolean enableWalkingStaminaRegen;
        public static double walkingStaminaRegenMultiplier;
        public static boolean enableEnergySystem;
        public static boolean speedBasedEnergyDrain;
        public static double energyLossRate;
        public static double walkingEnergyLossRate;
        public static double exhaustionThreshold;
        public static int exhaustionRecoveryTicks;
        public static boolean showExhaustionWarning;
        public static boolean enableSpeedMultiplier;
        public static double maxSpeedMultiplier;
    }
}

