/*
 * Decompiled with CFR 0.152.
 */
package realisticstamina.rstamina;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1309;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.server.MinecraftServer;
import realisticstamina.rstamina.RStaminaPlayerState;

public class ServerState
extends class_18 {
    public String worldVersion = "1.5.2";
    public Map<UUID, RStaminaPlayerState> players = new ConcurrentHashMap<UUID, RStaminaPlayerState>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_2487 method_75(class_2487 nbt) {
        HashMap<UUID, RStaminaPlayerState> playersCopy;
        class_2487 playersNbtCompound = new class_2487();
        Map<UUID, RStaminaPlayerState> map = this.players;
        synchronized (map) {
            playersCopy = new HashMap<UUID, RStaminaPlayerState>(this.players);
        }
        playersCopy.forEach((UUID2, playerState) -> {
            class_2487 playerStateNbt = new class_2487();
            playerStateNbt.method_10549("stamina", playerState.stamina);
            playerStateNbt.method_10549("maxStamina", playerState.maxStamina);
            playerStateNbt.method_10549("totalStamina", playerState.getTotalStamina());
            playerStateNbt.method_10549("energy", playerState.energy);
            playerStateNbt.method_10549("usedEnergy", playerState.usedEnergy);
            playerStateNbt.method_10549("energyFromResting", playerState.energyFromResting);
            playerStateNbt.method_10556("edited", playerState.edited);
            playerStateNbt.method_10549("customTotalStamina", playerState.customTotalStamina);
            playerStateNbt.method_10569("staminaRegenCooldown", playerState.staminaRegenCooldown);
            playerStateNbt.method_10569("miningFatigueCooldown", playerState.miningFatigueCooldown);
            playerStateNbt.method_10569("exhaustionRestTimer", playerState.exhaustionRestTimer);
            playerStateNbt.method_10556("isExhausted", playerState.isExhausted);
            playerStateNbt.method_10549("staminaLossRate", playerState.staminaLossRate);
            playerStateNbt.method_10549("staminaGainRate", playerState.staminaGainRate);
            playerStateNbt.method_10549("energyLossRate", playerState.energyLossRate);
            playerStateNbt.method_10549("energyGainRate", playerState.energyGainRate);
            playerStateNbt.method_10556("wasOnGround", playerState.wasOnGround);
            playerStateNbt.method_10569("miningBlockProgress", playerState.miningBlockProgress);
            playerStateNbt.method_10549("miningBonusStamina", playerState.miningBonusStamina);
            playerStateNbt.method_10549("gainedStamina", playerState.gainedStamina);
            playersNbtCompound.method_10566(String.valueOf(UUID2), (class_2520)playerStateNbt);
        });
        nbt.method_10566("players", (class_2520)playersNbtCompound);
        nbt.method_10582("worldVersion", this.worldVersion);
        return nbt;
    }

    public static ServerState createFromNbt(class_2487 tag) {
        ServerState serverState = new ServerState();
        class_2487 playersTag = tag.method_10562("players");
        playersTag.method_10541().forEach(key -> {
            RStaminaPlayerState playerState = new RStaminaPlayerState();
            playerState.stamina = playersTag.method_10562(key).method_10574("stamina");
            playerState.maxStamina = playersTag.method_10562(key).method_10574("maxStamina");
            playerState.totalStamina = playersTag.method_10562(key).method_10574("totalStamina");
            playerState.energy = playersTag.method_10562(key).method_10574("energy");
            playerState.usedEnergy = playersTag.method_10562(key).method_10574("usedEnergy");
            playerState.energyFromResting = playersTag.method_10562(key).method_10574("energyFromResting");
            playerState.edited = playersTag.method_10562(key).method_10577("edited");
            playerState.customTotalStamina = playersTag.method_10562(key).method_10545("customTotalStamina") ? playersTag.method_10562(key).method_10574("customTotalStamina") : -1.0;
            playerState.staminaRegenCooldown = playersTag.method_10562(key).method_10550("staminaRegenCooldown");
            playerState.miningFatigueCooldown = playersTag.method_10562(key).method_10550("miningFatigueCooldown");
            playerState.exhaustionRestTimer = playersTag.method_10562(key).method_10550("exhaustionRestTimer");
            playerState.isExhausted = playersTag.method_10562(key).method_10577("isExhausted");
            playerState.staminaLossRate = playersTag.method_10562(key).method_10574("staminaLossRate");
            playerState.staminaGainRate = playersTag.method_10562(key).method_10574("staminaGainRate");
            playerState.energyLossRate = playersTag.method_10562(key).method_10574("energyLossRate");
            playerState.energyGainRate = playersTag.method_10562(key).method_10574("energyGainRate");
            playerState.wasOnGround = playersTag.method_10562(key).method_10577("wasOnGround");
            playerState.miningBlockProgress = playersTag.method_10562(key).method_10550("miningBlockProgress");
            playerState.miningBonusStamina = playersTag.method_10562(key).method_10574("miningBonusStamina");
            if (playersTag.method_10562(key).method_10545("gainedStamina")) {
                playerState.gainedStamina = playersTag.method_10562(key).method_10574("gainedStamina");
            }
            UUID uuid = UUID.fromString(key);
            serverState.players.put(uuid, playerState);
        });
        serverState.worldVersion = tag.method_10558("worldVersion");
        return serverState;
    }

    public static ServerState getServerState(MinecraftServer server) {
        if (server == null || server.method_3847(class_1937.field_25179) == null) {
            return null;
        }
        class_26 persistentStateManager = server.method_3847(class_1937.field_25179).method_17983();
        ServerState serverState = (ServerState)persistentStateManager.method_17924(ServerState::createFromNbt, ServerState::new, "rstamina");
        return serverState;
    }

    public static RStaminaPlayerState getPlayerState(class_1309 player) {
        if (player == null || player.method_37908() == null || player.method_37908().method_8503() == null) {
            return new RStaminaPlayerState();
        }
        ServerState serverState = ServerState.getServerState(player.method_37908().method_8503());
        if (serverState == null) {
            return new RStaminaPlayerState();
        }
        return serverState.players.computeIfAbsent(player.method_5667(), uuid -> new RStaminaPlayerState());
    }
}

