/*
 * Decompiled with CFR 0.152.
 */
package realisticstamina.rstamina.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import realisticstamina.rstamina.RStaminaClient;
import realisticstamina.rstamina.RStaminaConfig;
import realisticstamina.rstamina.RStaminaMod;

public class StaminaHudOverlay
implements HudRenderCallback {
    private static final int BAR_WIDTH = 72;
    private static final int BAR_HEIGHT = 4;
    private static final int SPACING = 3;
    private static final int CORNER_RADIUS = 0;
    private static double lastStaminaPercentage = 1.0;
    private static double lastEnergyPercentage = 1.0;
    private static final double ANIMATION_SPEED = 0.15;

    public void onHudRender(class_332 drawContext, float tickDelta) {
        int hudAnchorX = RStaminaMod.config.hudX;
        int hudAnchorY = RStaminaMod.config.hudY;
        float globalScale = (float)RStaminaMod.config.hudScale;
        class_310 client = class_310.method_1551();
        if (client != null && RStaminaClient.showingStaminaTicks > 0) {
            float alpha = Math.min(1.0f, (float)RStaminaClient.showingStaminaTicks / 20.0f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_46416((float)hudAnchorX, (float)hudAnchorY, 0.0f);
            drawContext.method_51448().method_22905(globalScale, globalScale, 1.0f);
            int x = 0;
            int y = 0;
            class_327 textRenderer = client.field_1772;
            float textScale = 0.75f;
            double stamina = RStaminaClient.clientStoredStamina;
            double maxStamina = RStaminaClient.clientStoredMaxStamina;
            double targetStaminaPercentage = Math.min(1.0, Math.max(0.0, stamina / maxStamina));
            double energy = RStaminaClient.clientStoredEnergy;
            double targetEnergyPercentage = Math.min(1.0, Math.max(0.0, energy / 100.0));
            lastStaminaPercentage += (targetStaminaPercentage - lastStaminaPercentage) * 0.15;
            lastEnergyPercentage += (targetEnergyPercentage - lastEnergyPercentage) * 0.15;
            int staminaColor = lastStaminaPercentage > 0.6 ? -10879143 : (lastStaminaPercentage > 0.3 ? -7335 : -42663);
            this.drawFilledRect(drawContext, x, y, x + 72, y + 4, Integer.MIN_VALUE);
            int fillWidth = (int)(72.0 * lastStaminaPercentage);
            if (fillWidth > 0) {
                this.drawFilledRect(drawContext, x, y, x + fillWidth, y + 4, staminaColor);
            }
            int energyBarY = y + 4 + 3;
            this.drawFilledRect(drawContext, x, energyBarY, x + 72, energyBarY + 4, Integer.MIN_VALUE);
            int energyColor = -10773505;
            fillWidth = (int)(72.0 * lastEnergyPercentage);
            if (fillWidth > 0) {
                this.drawFilledRect(drawContext, x, energyBarY, x + fillWidth, energyBarY + 4, energyColor);
            }
            if (RStaminaMod.config.hudStyle == RStaminaConfig.HudStyle.DETAILED) {
                int textX = 75;
                Objects.requireNonNull(textRenderer);
                float scaledTextHeight = 9.0f * textScale;
                int staminaTextY = (int)((float)y + (4.0f - scaledTextHeight) / 2.0f);
                int energyTextY = (int)((float)energyBarY + (4.0f - scaledTextHeight) / 2.0f);
                String staminaValue = String.format("%.0f/%.0f", stamina, maxStamina);
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_46416((float)textX, (float)staminaTextY, 0.0f);
                drawContext.method_51448().method_22905(textScale, textScale, 1.0f);
                drawContext.method_25303(textRenderer, staminaValue, 0, 0, staminaColor);
                drawContext.method_51448().method_22909();
                String energyValue = String.format("%.0f", energy);
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_46416((float)textX, (float)energyTextY, 0.0f);
                drawContext.method_51448().method_22905(textScale, textScale, 1.0f);
                drawContext.method_25303(textRenderer, energyValue, 0, 0, energyColor);
                drawContext.method_51448().method_22909();
            }
            if (RStaminaClient.showSpeedMultiplierTicks > 0) {
                float speedAlpha = Math.min(1.0f, (float)RStaminaClient.showSpeedMultiplierTicks / 20.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)speedAlpha);
                if (RStaminaClient.clientStoredSpeedMultiplier > 1.01) {
                    String speedText = String.format("\u00d7%.1f", RStaminaClient.clientStoredSpeedMultiplier);
                    int speedY = energyBarY + 4 + 3 + 2;
                    drawContext.method_51448().method_22903();
                    float scaledTextWidth = (float)textRenderer.method_1727(speedText) * textScale;
                    float centeredTextX = (float)x + (72.0f - scaledTextWidth) / 2.0f;
                    drawContext.method_51448().method_46416(centeredTextX, (float)speedY, 0.0f);
                    drawContext.method_51448().method_22905(textScale, textScale, 1.0f);
                    drawContext.method_25303(textRenderer, speedText, 0, 0, -10878977);
                    drawContext.method_51448().method_22909();
                }
            }
            drawContext.method_51448().method_22909();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    private void drawFilledRect(class_332 drawContext, int left, int top, int right, int bottom, int color) {
        drawContext.method_25294(left, top, right, bottom, color);
    }
}

