/*
 * Decompiled with CFR 0.152.
 */
package me.kall.lastwords.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JsonConfig {
    private static final JsonParser PARSER = new JsonParser();
    private final Path configPath;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, JsonElement> configMap = new Object2ObjectOpenHashMap();
    public static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();

    private JsonConfig(@NotNull Path configPath, String version) {
        this.configPath = configPath;
        this.put("Version", version);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static JsonConfig create(Path configPath, String version) {
        return new JsonConfig(configPath, version);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static JsonConfig create(String modID, String version) {
        return JsonConfig.create(CONFIG_DIR.resolve(modID + ".json"), version);
    }

    public JsonConfig initialize() {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            this.read();
        } else {
            this.create();
        }
        return this;
    }

    private void read() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.configPath.toFile()));){
            JsonObject fileConfig = PARSER.parse((Reader)reader).getAsJsonObject();
            Object2ObjectOpenHashMap defaultConfig = new Object2ObjectOpenHashMap(this.configMap);
            this.configMap.clear();
            for (Map.Entry entry : fileConfig.entrySet()) {
                this.configMap.put((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            for (Map.Entry entry : defaultConfig.entrySet()) {
                if (this.configMap.containsKey(entry.getKey())) continue;
                this.configMap.put((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            JsonElement fileVersion = fileConfig.get("Version");
            if (fileVersion == null || !fileVersion.getAsString().equals(((JsonElement)defaultConfig.get("Version")).getAsString())) {
                this.configMap.put("Version", (JsonElement)defaultConfig.get("Version"));
                this.update();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config file: " + String.valueOf(this.configPath), e);
        }
    }

    private void create() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            this.saveToFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create config file: " + String.valueOf(this.configPath), e);
        }
    }

    private void update() {
        this.saveToFile();
    }

    private void saveToFile() {
        try (FileWriter writer = new FileWriter(this.configPath.toFile());){
            this.gson.toJson(this.configMap, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config file: " + String.valueOf(this.configPath), e);
        }
    }

    public JsonConfig put(String key, Object value) {
        this.configMap.put(key, this.gson.toJsonTree(value));
        return this;
    }

    private JsonElement get(String key) {
        return this.configMap.get(key);
    }

    public int getInt(String key) {
        return this.get(key).getAsInt();
    }

    public double getDouble(String key) {
        return this.get(key).getAsDouble();
    }

    public float getFloat(String key) {
        return this.get(key).getAsFloat();
    }

    public long getLong(String key) {
        return this.get(key).getAsLong();
    }

    public boolean getBoolean(String key) {
        return this.get(key).getAsBoolean();
    }

    public String getString(String key) {
        return this.get(key).getAsString();
    }

    public <T> Stream<T> getStream(String key, @NotNull Class<T> valueType) {
        return StreamSupport.stream(this.configMap.get(key).getAsJsonArray().spliterator(), false).map(element -> this.gson.fromJson(element, valueType));
    }

    public <T> List<T> getList(String key, @NotNull Class<T> valueType) {
        return this.getStream(key, valueType).collect(Collectors.toList());
    }

    public <T> Set<T> getSet(String key, @NotNull Class<T> valueType) {
        return this.getStream(key, valueType).collect(Collectors.toSet());
    }
}

