/*
 * Decompiled with CFR 0.152.
 */
package me.kall.lastwords.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import me.kall.lastwords.LastWords;
import me.kall.lastwords.ext.DongZhuo;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements DongZhuo {
    @Unique
    private boolean lastWords$said;

    @Override
    public boolean lastWords$said() {
        return this.lastWords$said;
    }

    @Override
    public void lastWords$setSaid(boolean said) {
        this.lastWords$said = said;
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void save(@NotNull CompoundTag compound, CallbackInfo ci) {
        compound.putBoolean("LastWordsSaid", this.lastWords$said());
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void load(@NotNull CompoundTag compound, CallbackInfo ci) {
        this.lastWords$setSaid(compound.getBoolean("LastWordsSaid"));
    }

    @WrapOperation(method={"actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setHealth(F)V")})
    private void onHurt(LivingEntity attacked, float health, Operation<Void> original, @Local(argsOnly=true) DamageSource damageSource) {
        Entity attacker = damageSource.getEntity();
        if (attacker instanceof Player) {
            Player lvBu = (Player)attacker;
            if (health <= 0.0f && !attacker.level().isClientSide() && (attacked instanceof Player || attacked.isAlliedTo((Entity)lvBu))) {
                if (((DongZhuo)attacked).lastWords$said()) {
                    ((DongZhuo)attacked).lastWords$setSaid(false);
                    original.call(new Object[]{attacked, Float.valueOf(health)});
                    return;
                }
                MutableComponent lvBuWords = Component.literal((String)("<" + lvBu.getName().getString() + "> " + I18n.get((String)"lv_bu.last_words", (Object[])new Object[0])));
                MutableComponent dongZhuoWords = Component.literal((String)("<" + attacked.getName().getString() + "> " + I18n.get((String)"dong_zhuo.last_words", (Object[])new Object[0])));
                lvBu.displayClientMessage((Component)lvBuWords, false);
                lvBu.displayClientMessage((Component)dongZhuoWords, false);
                if (attacked instanceof Player) {
                    Player dongZhuo = (Player)attacked;
                    dongZhuo.displayClientMessage((Component)lvBuWords, false);
                    dongZhuo.displayClientMessage((Component)dongZhuoWords, false);
                }
                health = 1.0f;
                if (((Boolean)LastWords.Config.EFFECT.get()).booleanValue()) {
                    attacked.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, ((Integer)LastWords.Config.EFFECT_DURATION.get()).intValue(), ((Integer)LastWords.Config.EFFECT_LEVEL.get()).intValue(), false, false, false));
                    attacked.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, ((Integer)LastWords.Config.EFFECT_DURATION.get()).intValue(), ((Integer)LastWords.Config.EFFECT_LEVEL.get()).intValue(), false, false, false));
                }
                ((DongZhuo)attacked).lastWords$setSaid(true);
            }
        }
        original.call(new Object[]{attacked, Float.valueOf(health)});
    }
}

