/*
 * Decompiled with CFR 0.152.
 */
package wtf.blexyel.simpleCameraTweaks.mixin;

import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wtf.blexyel.simpleCameraTweaks.util.Zoom;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Inject(method={"getFov(Lnet/minecraft/client/Camera;FZ)F"}, at={@At(value="TAIL")}, cancellable=true)
    private void onGetFov(Camera camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<?> cir) {
        this.handleNewVersion(camera, tickDelta, changingFov, cir);
    }

    @Unique
    private void handleNewVersion(Camera camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Float> cir) {
        float baseFov = ((Float)cir.getReturnValue()).floatValue();
        Zoom.updateZoomState();
        float targetFov = Zoom.isZoomin ? Mth.clamp((float)(baseFov * Zoom.zoomedFovScale), (float)1.0f, (float)110.0f) : baseFov;
        Zoom.actualZoomLevel = Zoom.targetZoomLevel;
        cir.setReturnValue((Object)Float.valueOf(targetFov));
    }
}

