/*
 * Decompiled with CFR 0.152.
 */
package wtf.blexyel.simple_camera_tweaks.mixin;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wtf.blexyel.simple_camera_tweaks.util.Zoom;

@Mixin(value={class_757.class})
public class GameRendererMixin {
    @Unique
    private static final boolean IS_NEW_VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata().getVersion().getFriendlyString().compareTo("1.21.2") >= 0;

    @Inject(method={"getFov"}, at={@At(value="TAIL")}, cancellable=true)
    private void onGetFov(class_4184 camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<?> cir) {
        if (IS_NEW_VERSION) {
            this.handleNewVersion(camera, tickDelta, changingFov, cir);
        } else {
            this.handleOldVersion(camera, tickDelta, changingFov, cir);
        }
    }

    @Unique
    private void handleNewVersion(class_4184 camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Float> cir) {
        float baseFov = ((Float)cir.getReturnValue()).floatValue();
        Zoom.updateZoomState();
        Zoom.targetZoomLevel = Zoom.isZooming() ? baseFov * Zoom.zoomedFovScale : baseFov;
        Zoom.calculateZoom();
        cir.setReturnValue((Object)Float.valueOf(Zoom.actualZoomLevel));
    }

    @Unique
    private void handleOldVersion(class_4184 camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Double> cir) {
        double baseFov = (Double)cir.getReturnValue();
        Zoom.updateZoomState();
        Zoom.targetZoomLevel = Zoom.isZooming() ? (float)(baseFov * (double)Zoom.zoomedFovScale) : (float)baseFov;
        Zoom.calculateZoom();
        cir.setReturnValue((Object)Zoom.actualZoomLevel);
    }
}

