/*
 * Decompiled with CFR 0.152.
 */
package wtf.blexyel.simpleCameraTweaks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import wtf.blexyel.simpleCameraTweaks.SimpleCameraTweaks;

public class Config {
    public static boolean smooth = false;
    public static boolean offhand = false;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/simple_camera_tweaks.json");

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            Config.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (json.has("enabled") && !json.has("offhand")) {
                offhand = json.get("enabled").getAsBoolean();
                SimpleCameraTweaks.LOGGER.info("Migrated 'enabled' to 'offhand'");
            } else if (json.has("offhand")) {
                offhand = json.get("offhand").getAsBoolean();
            }
            if (json.has("smooth")) {
                smooth = json.get("smooth").getAsBoolean();
            }
        }
        catch (JsonParseException | IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            JsonObject json = new JsonObject();
            json.addProperty("smooth", Boolean.valueOf(smooth));
            json.addProperty("offhand", Boolean.valueOf(offhand));
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

