/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.block.custom.beam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.chris.chris_s_additions.block.AllBlocks;
import net.chris.chris_s_additions.item.AllItems;
import net.chris.chris_s_additions.item.custom.ChiselItem;
import net.chris.chris_s_additions.screen.ChiselHudRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class AbstractBeamBlock
extends class_2248
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 Y_SIDE = class_2746.method_11825((String)"y_side");
    public static final class_2746 X_SIDE = class_2746.method_11825((String)"x_side");
    public static final class_2746 Z_SIDE = class_2746.method_11825((String)"z_side");
    public static final class_2746 Y_F_SIDE = class_2746.method_11825((String)"vertical_side");
    public static final class_2746 X_F_SIDE = class_2746.method_11825((String)"horizontal_x_side");
    public static final class_2746 Z_F_SIDE = class_2746.method_11825((String)"horizontal_z_side");
    private static final long CHISEL_COOLDOWN_TICKS = 10L;
    private static final Map<String, Long> chiselCooldowns = new HashMap<String, Long>();

    public AbstractBeamBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)Y_SIDE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)X_SIDE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)Z_SIDE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)Y_F_SIDE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)X_F_SIDE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)Z_F_SIDE, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2338 pos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        class_3610 fluidState = world.method_8316(pos);
        boolean isWaterlogged = fluidState.method_15772() == class_3612.field_15910;
        class_2680 existingState = world.method_8320(pos);
        if (existingState.method_26204() instanceof AbstractBeamBlock) {
            boolean y = (Boolean)existingState.method_11654((class_2769)Y_SIDE);
            boolean x = (Boolean)existingState.method_11654((class_2769)X_SIDE);
            boolean z = (Boolean)existingState.method_11654((class_2769)Z_SIDE);
            class_2350 facingDirection = ctx.method_8038();
            class_2350.class_2351 axis = facingDirection.method_10166();
            if (axis == class_2350.class_2351.field_11052 && !y) {
                existingState = (class_2680)existingState.method_11657((class_2769)Y_SIDE, (Comparable)Boolean.valueOf(true));
            } else if (axis == class_2350.class_2351.field_11048 && !x) {
                existingState = (class_2680)existingState.method_11657((class_2769)X_SIDE, (Comparable)Boolean.valueOf(true));
            } else if (axis == class_2350.class_2351.field_11051 && !z) {
                existingState = (class_2680)existingState.method_11657((class_2769)Z_SIDE, (Comparable)Boolean.valueOf(true));
            } else {
                return null;
            }
            if (((Boolean)existingState.method_11654((class_2769)Y_SIDE)).booleanValue() && ((Boolean)existingState.method_11654((class_2769)X_SIDE)).booleanValue() && ((Boolean)existingState.method_11654((class_2769)Z_SIDE)).booleanValue()) {
                existingState = (class_2680)((class_2680)((class_2680)existingState.method_11657((class_2769)Y_F_SIDE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)X_F_SIDE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)Z_F_SIDE, (Comparable)Boolean.valueOf(false));
            }
            return existingState;
        }
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
        class_2350.class_2351 axis = ctx.method_8038().method_10166();
        if (axis == class_2350.class_2351.field_11052) {
            state = (class_2680)((class_2680)state.method_11657((class_2769)Y_SIDE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)Y_F_SIDE, (Comparable)Boolean.valueOf(true));
        }
        if (axis == class_2350.class_2351.field_11048) {
            state = (class_2680)((class_2680)state.method_11657((class_2769)X_SIDE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)X_F_SIDE, (Comparable)Boolean.valueOf(true));
        }
        if (axis == class_2350.class_2351.field_11051) {
            state = (class_2680)((class_2680)state.method_11657((class_2769)Z_SIDE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)Z_F_SIDE, (Comparable)Boolean.valueOf(true));
        }
        if (((Boolean)state.method_11654((class_2769)Y_SIDE)).booleanValue() && ((Boolean)state.method_11654((class_2769)X_SIDE)).booleanValue() && ((Boolean)state.method_11654((class_2769)Z_SIDE)).booleanValue()) {
            state = (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)Y_F_SIDE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)X_F_SIDE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)Z_F_SIDE, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        if (context.method_8046() || context.method_8041().method_7909() != this.method_8389()) {
            return false;
        }
        class_2350.class_2351 axis = context.method_8038().method_10166();
        if (axis == class_2350.class_2351.field_11052 && !((Boolean)state.method_11654((class_2769)Y_SIDE)).booleanValue()) {
            return true;
        }
        if (axis == class_2350.class_2351.field_11048 && !((Boolean)state.method_11654((class_2769)X_SIDE)).booleanValue()) {
            return true;
        }
        if (axis == class_2350.class_2351.field_11051 && !((Boolean)state.method_11654((class_2769)Z_SIDE)).booleanValue()) {
            return true;
        }
        return super.method_9616(state, context);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, Y_SIDE, X_SIDE, Z_SIDE, Y_F_SIDE, X_F_SIDE, Z_F_SIDE});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2248 strippedBlock;
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() instanceof class_1743 && (strippedBlock = this.getStrippedBeam(this)) != null) {
            class_2680 strippedState = strippedBlock.method_9564();
            for (class_2769 property : state.method_28501()) {
                if (!strippedState.method_28498(property)) continue;
                strippedState = this.copyProperty(state, strippedState, property);
            }
            world.method_8501(pos, strippedState);
            world.method_8396(null, pos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            return class_1269.field_5812;
        }
        if (stack.method_7909() instanceof ChiselItem && !world.field_9236) {
            boolean z;
            boolean x;
            long cooldown;
            String blockKey = "" + pos.method_10063();
            String playerKey = player.method_5845();
            String key = playerKey + "_" + blockKey;
            long currentTime = world.method_8510();
            long lastTime = chiselCooldowns.getOrDefault(key, 0L);
            long l = cooldown = stack.method_31574(AllItems.GOLDEN_CHISEL) ? 7L : 10L;
            if (currentTime - lastTime < cooldown) {
                return class_1269.field_21466;
            }
            boolean y = (Boolean)state.method_11654((class_2769)Y_SIDE);
            int activeCount = (y ? 1 : 0) + ((x = ((Boolean)state.method_11654((class_2769)X_SIDE)).booleanValue()) ? 1 : 0) + ((z = ((Boolean)state.method_11654((class_2769)Z_SIDE)).booleanValue()) ? 1 : 0);
            if (activeCount != 2) {
                return class_1269.field_21466;
            }
            class_2680 newState = state;
            class_2746[] sides = new class_2746[2];
            class_2746[] fSides = new class_2746[2];
            int index = 0;
            if (y) {
                sides[index] = Y_SIDE;
                fSides[index++] = Y_F_SIDE;
            }
            if (x) {
                sides[index] = X_SIDE;
                fSides[index++] = X_F_SIDE;
            }
            if (z) {
                sides[index] = Z_SIDE;
                fSides[index++] = Z_F_SIDE;
            }
            boolean firstIsTrue = (Boolean)state.method_11654((class_2769)fSides[0]);
            boolean secondIsTrue = (Boolean)state.method_11654((class_2769)fSides[1]);
            newState = firstIsTrue ? (class_2680)((class_2680)newState.method_11657((class_2769)fSides[0], (Comparable)Boolean.valueOf(false))).method_11657((class_2769)fSides[1], (Comparable)Boolean.valueOf(true)) : (secondIsTrue ? (class_2680)((class_2680)newState.method_11657((class_2769)fSides[1], (Comparable)Boolean.valueOf(false))).method_11657((class_2769)fSides[0], (Comparable)Boolean.valueOf(true)) : (class_2680)newState.method_11657((class_2769)fSides[0], (Comparable)Boolean.valueOf(true)));
            world.method_8652(pos, newState, 3);
            world.method_8396(null, pos, this.getChiselSound(state.method_26204()), class_3419.field_15245, 0.8f, 1.0f);
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5, 0.3, 0.3, 0.3, 0.05);
            }
            chiselCooldowns.put(key, currentTime);
            ChiselHudRenderer.ChiselRenderState.lastChiselUseTime = world.method_8510();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private class_3414 getChiselSound(class_2248 block) {
        if (block == AllBlocks.STRIPPED_CRIMSON_BEAM || block == AllBlocks.STRIPPED_WARPED_BEAM || block == AllBlocks.STRIPPED_SOUL_OAK_BEAM) {
            return class_3417.field_40097;
        }
        if (block == AllBlocks.CRIMSON_BEAM || block == AllBlocks.WARPED_BEAM || block == AllBlocks.SOUL_OAK_BEAM) {
            return class_3417.field_21887;
        }
        if (block == AllBlocks.BAMBOO_BEAM || block == AllBlocks.STRIPPED_BAMBOO_BEAM) {
            return class_3417.field_14740;
        }
        if (block == AllBlocks.CHERRY_BEAM || block == AllBlocks.STRIPPED_CHERRY_BEAM) {
            return class_3417.field_42573;
        }
        return class_3417.field_15215;
    }

    private <T extends Comparable<T>> class_2680 copyProperty(class_2680 from, class_2680 to, class_2769<T> property) {
        return (class_2680)to.method_11657(property, from.method_11654(property));
    }

    private class_2248 getStrippedBeam(class_2248 original) {
        if (original == AllBlocks.OAK_BEAM) {
            return AllBlocks.STRIPPED_OAK_BEAM;
        }
        if (original == AllBlocks.SPRUCE_BEAM) {
            return AllBlocks.STRIPPED_SPRUCE_BEAM;
        }
        if (original == AllBlocks.BIRCH_BEAM) {
            return AllBlocks.STRIPPED_BIRCH_BEAM;
        }
        if (original == AllBlocks.JUNGLE_BEAM) {
            return AllBlocks.STRIPPED_JUNGLE_BEAM;
        }
        if (original == AllBlocks.ACACIA_BEAM) {
            return AllBlocks.STRIPPED_ACACIA_BEAM;
        }
        if (original == AllBlocks.DARK_OAK_BEAM) {
            return AllBlocks.STRIPPED_DARK_OAK_BEAM;
        }
        if (original == AllBlocks.MANGROVE_BEAM) {
            return AllBlocks.STRIPPED_MANGROVE_BEAM;
        }
        if (original == AllBlocks.CHERRY_BEAM) {
            return AllBlocks.STRIPPED_CHERRY_BEAM;
        }
        if (original == AllBlocks.BAMBOO_BEAM) {
            return AllBlocks.STRIPPED_BAMBOO_BEAM;
        }
        if (original == AllBlocks.CRIMSON_BEAM) {
            return AllBlocks.STRIPPED_CRIMSON_BEAM;
        }
        if (original == AllBlocks.WARPED_BEAM) {
            return AllBlocks.STRIPPED_WARPED_BEAM;
        }
        if (original == AllBlocks.SOUL_OAK_BEAM) {
            return AllBlocks.STRIPPED_SOUL_OAK_BEAM;
        }
        return null;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.beam_tooltip").method_27692(class_124.field_1068));
            tooltip.addAll(this.wrapText(class_2561.method_43471((String)"tooltip.beam_chisel_info").getString(), 50));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"Hold \u00a7e[SHIFT]\u00a7r for more info").method_27692(class_124.field_1080));
        }
    }

    private List<class_2561> wrapText(String text, int maxLength) {
        ArrayList<class_2561> wrappedLines = new ArrayList<class_2561>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() + word.length() > maxLength) {
                wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
                line = new StringBuilder();
            }
            line.append(word).append(" ");
        }
        if (!line.isEmpty()) {
            wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
        }
        return wrappedLines;
    }
}

