/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.screen;

import java.util.List;
import net.chris.chris_s_additions.recipe.CarpentryRecipe;
import net.chris.chris_s_additions.screen.CarpenterTableScreenHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class CarpenterTableScreen
extends class_465<CarpenterTableScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("chris_s_additions", "textures/gui/container/carpenter_table.png");
    private static final int SCROLLBAR_WIDTH = 12;
    private static final int SCROLLBAR_HEIGHT = 15;
    private static final int RECIPE_LIST_COLUMNS = 4;
    private static final int RECIPE_LIST_ROWS = 3;
    private static final int RECIPE_ENTRY_WIDTH = 16;
    private static final int RECIPE_ENTRY_HEIGHT = 18;
    private static final int SCROLLBAR_AREA_HEIGHT = 54;
    private static final int RECIPE_LIST_OFFSET_X = 52;
    private static final int RECIPE_LIST_OFFSET_Y = 14;
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;
    private boolean canCraft;

    public CarpenterTableScreen(CarpenterTableScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        --this.field_25268;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        this.method_25420(context);
        int i = this.field_2776;
        int j = this.field_2800;
        context.method_25302(TEXTURE, i, j, 0, 0, this.field_2792, this.field_2779);
        int k = (int)(41.0f * this.scrollAmount);
        context.method_25302(TEXTURE, i + 119, j + 15 + k, 176 + (this.shouldScroll() ? 0 : 16), 0, 12, 15);
        int l = this.field_2776 + 52;
        int m = this.field_2800 + 14;
        int n = this.scrollOffset + 12;
        this.renderRecipeBackground(context, mouseX, mouseY, l, m, n);
        this.renderRecipeIcons(context, l, m, n);
    }

    protected void method_2380(class_332 context, int x, int y) {
        super.method_2380(context, x, y);
        if (this.canCraft) {
            int i = this.field_2776 + 52;
            int j = this.field_2800 + 14;
            int k = this.scrollOffset + 12;
            List<CarpentryRecipe> list = ((CarpenterTableScreenHandler)this.field_2797).getAvailableRecipes();
            for (int l = this.scrollOffset; l < k && l < ((CarpenterTableScreenHandler)this.field_2797).getAvailableRecipeCount(); ++l) {
                int m = l - this.scrollOffset;
                int n = i + m % 4 * 16;
                int o = j + m / 4 * 18 + 2;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                context.method_51446(this.field_22793, list.get(l).method_8110(this.field_22787.field_1687.method_30349()), x, y);
            }
        }
    }

    private void renderRecipeBackground(class_332 context, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((CarpenterTableScreenHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            int j = i - this.scrollOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            int s = this.field_2776 + 211;
            if (i == ((CarpenterTableScreenHandler)this.field_2797).getSelectedRecipe()) {
                s += 16;
            } else if (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18) {
                s += 32;
            }
            context.method_25302(TEXTURE, k, m - 1, s, 0, 16, 18);
        }
    }

    private void renderRecipeIcons(class_332 context, int x, int y, int scrollOffset) {
        List<CarpentryRecipe> list = ((CarpenterTableScreenHandler)this.field_2797).getAvailableRecipes();
        for (int i = this.scrollOffset; i < scrollOffset && i < ((CarpenterTableScreenHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            int j = i - this.scrollOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            context.method_51427(list.get(i).method_8110(this.field_22787.field_1687.method_30349()), k, m);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.canCraft) {
            int i = this.field_2776 + 52;
            int j = this.field_2800 + 14;
            int k = this.scrollOffset + 12;
            for (int l = this.scrollOffset; l < k; ++l) {
                int m = l - this.scrollOffset;
                double d = mouseX - (double)(i + m % 4 * 16);
                double e = mouseY - (double)(j + m / 4 * 18);
                if (!(d >= 0.0) || !(e >= 0.0) || !(d < 16.0) || !(e < 18.0) || !((CarpenterTableScreenHandler)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, l)) continue;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                this.field_22787.field_1761.method_2900(((CarpenterTableScreenHandler)this.field_2797).field_7763, l);
                return true;
            }
            i = this.field_2776 + 119;
            j = this.field_2800 + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.field_2800 + 14;
            int j = i + 54;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            float f = (float)amount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean shouldScroll() {
        return this.canCraft && ((CarpenterTableScreenHandler)this.field_2797).getAvailableRecipeCount() > 12;
    }

    protected int getMaxScroll() {
        return (((CarpenterTableScreenHandler)this.field_2797).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268 - 1, -4683701, true);
        context.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, -4683701, true);
    }

    private void onInventoryChange() {
        this.canCraft = ((CarpenterTableScreenHandler)this.field_2797).canCraft();
        if (!this.canCraft) {
            this.scrollAmount = 0.0f;
            this.scrollOffset = 0;
        }
    }
}

