/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.chris.chris_s_additions.block.AllBlocks;
import net.chris.chris_s_additions.block.custom.beam.AbstractBeamBlock;
import net.chris.chris_s_additions.block.custom.chiseled_pillars.ChiseledPillarBlock;
import net.chris.chris_s_additions.block.custom.properties.PillarShape;
import net.chris.chris_s_additions.events.KeyInputHandler;
import net.chris.chris_s_additions.util.ModTags;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5498;
import net.minecraft.class_6862;
import net.minecraft.class_761;
import org.joml.Matrix4f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class ChiselHudRenderer
implements HudRenderCallback {
    private static final class_2960 CHISEL_ICON = new class_2960("chris_s_additions", "textures/gui/hud/chisel_icon.png");
    private final class_310 client = class_310.method_1551();
    private final class_6862<class_1792> chiselTag;
    private final class_6862<class_2248> chiselableTag;
    private static final Map<class_2338, Long> blockLookStartTimes = new HashMap<class_2338, Long>();
    private static KeyInputHandler.GuidanceBlockOutlineMode lastMode = null;
    private static class_2338 lastLookedPos = null;
    private static int lastSelectedSlot = -1;

    public ChiselHudRenderer(class_6862<class_1792> chiselTag, class_6862<class_2248> chiselableTag) {
        this.chiselTag = chiselTag;
        this.chiselableTag = chiselableTag;
    }

    public void onHudRender(class_332 drawContext, float tickDelta) {
        if (this.client.field_1724 == null || this.client.field_1687 == null) {
            return;
        }
        class_1799 mainHandStack = this.client.field_1724.method_6047();
        class_1799 offHandStack = this.client.field_1724.method_6079();
        if (this.client.field_1690.method_31044() != class_5498.field_26664) {
            return;
        }
        if (this.client.field_1724.method_7325()) {
            return;
        }
        class_1934 gameMode = this.client.field_1761.method_2920();
        if (gameMode == class_1934.field_9216) {
            return;
        }
        if (!mainHandStack.method_31573(this.chiselTag) && !offHandStack.method_31573(this.chiselTag)) {
            return;
        }
        class_239 hit = this.client.field_1765;
        if (!(hit instanceof class_3965)) {
            return;
        }
        class_3965 blockHit = (class_3965)hit;
        class_2338 pos = blockHit.method_17777();
        class_2680 state = this.client.field_1687.method_8320(pos);
        if (!state.method_26164(this.chiselableTag)) {
            return;
        }
        boolean isBeamBlock = state.method_26164(ModTags.BEAMS);
        if (isBeamBlock && !ChiselHudRenderer.canChiselBeamBlock(state)) {
            return;
        }
        int screenWidth = this.client.method_22683().method_4486();
        int screenHeight = this.client.method_22683().method_4502();
        this.renderChiselIcon(drawContext, screenWidth, screenHeight, tickDelta);
    }

    private void renderChiselIcon(class_332 context, int screenWidth, int screenHeight, float tickDelta) {
        class_310 client = class_310.method_1551();
        int x = screenWidth / 2 + 4;
        int y = screenHeight / 2 - 12;
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        float time = ((float)client.field_1687.method_8510() + tickDelta) * 0.5f;
        float pulse = (class_3532.method_15374((float)time) + 1.0f) / 2.0f;
        float alpha = 0.6f + 0.4f * pulse;
        context.method_51422(1.0f, 1.0f, 1.0f, alpha);
        context.method_25290(CHISEL_ICON, x, y, 0.0f, 0.0f, 8, 8, 8, 8);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
    }

    private static boolean canChiselBeamBlock(class_2680 state) {
        boolean y = (Boolean)state.method_11654((class_2769)AbstractBeamBlock.Y_SIDE);
        boolean x = (Boolean)state.method_11654((class_2769)AbstractBeamBlock.X_SIDE);
        boolean z = (Boolean)state.method_11654((class_2769)AbstractBeamBlock.Z_SIDE);
        int activeCount = (y ? 1 : 0) + (x ? 1 : 0) + (z ? 1 : 0);
        return activeCount == 2;
    }

    public static void renderChiselHighlight(WorldRenderContext context) {
        class_265 shape;
        long currentTime;
        boolean chiselJustUsed;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_1799 mainHandStack = client.field_1724.method_6047();
        class_1799 offHandStack = client.field_1724.method_6079();
        if (KeyInputHandler.guidanceblockoutlineMode == KeyInputHandler.GuidanceBlockOutlineMode.OFF) {
            return;
        }
        if (client.field_1690.field_1842) {
            return;
        }
        class_1934 gm = client.field_1761.method_2920();
        if (gm == class_1934.field_9219 || gm == class_1934.field_9216) {
            return;
        }
        class_239 hit = client.field_1765;
        class_2338 pos = null;
        if (hit instanceof class_3965) {
            class_3965 bhr = (class_3965)hit;
            pos = bhr.method_17777();
        }
        boolean bl = chiselJustUsed = ChiselRenderState.lastChiselUseTime == (currentTime = client.field_1687.method_8510());
        if (pos == null || !pos.equals((Object)lastLookedPos) || chiselJustUsed) {
            if (lastLookedPos != null) {
                blockLookStartTimes.remove(lastLookedPos);
            }
            if (pos != null) {
                blockLookStartTimes.put(pos, currentTime);
            }
            lastLookedPos = pos;
        }
        if (pos == null) {
            return;
        }
        class_2680 state = client.field_1687.method_8320(pos);
        if (!state.method_26164(ModTags.CHISELABLE_BLOCKS)) {
            return;
        }
        boolean isBeamBlock = state.method_26164(ModTags.BEAMS);
        if (isBeamBlock && !ChiselHudRenderer.canChiselBeamBlock(state)) {
            return;
        }
        boolean modeChanged = KeyInputHandler.guidanceblockoutlineMode != lastMode;
        int currentSlot = client.field_1724.method_31548().field_7545;
        if (currentSlot != lastSelectedSlot) {
            if (lastLookedPos != null) {
                blockLookStartTimes.put(lastLookedPos, client.field_1687.method_8510());
            }
            lastSelectedSlot = currentSlot;
        }
        if (!mainHandStack.method_31573(ModTags.CHISELS) && !offHandStack.method_31573(ModTags.CHISELS)) {
            return;
        }
        if (modeChanged && pos != null) {
            blockLookStartTimes.put(pos, currentTime);
            lastMode = KeyInputHandler.guidanceblockoutlineMode;
        }
        long startTime = blockLookStartTimes.getOrDefault(pos, currentTime);
        long elapsed = currentTime - startTime;
        float alpha = 1.0f;
        if (KeyInputHandler.guidanceblockoutlineMode == KeyInputHandler.GuidanceBlockOutlineMode.FADING) {
            float fadeInDuration = 8.0f;
            float holdMaxDuration = 35.0f;
            float fadeOutDuration = 15.0f;
            float holdMinDuration = 4.0f;
            float totalCycle = fadeInDuration + holdMaxDuration + fadeOutDuration + holdMinDuration;
            float time = ((float)elapsed + client.method_1488()) % totalCycle;
            if (time < fadeInDuration) {
                alpha = time / fadeInDuration;
            } else if (time < fadeInDuration + holdMaxDuration) {
                alpha = 1.0f;
            } else if (time < fadeInDuration + holdMaxDuration + fadeOutDuration) {
                float t = time - (fadeInDuration + holdMaxDuration);
                alpha = 1.0f - t / fadeOutDuration;
            } else {
                alpha = 0.0f;
            }
        }
        String part = "default";
        if (state.method_26204() instanceof ChiseledPillarBlock && state.method_28498(ChiseledPillarBlock.PILLAR_SHAPE)) {
            part = ((PillarShape)((Object)state.method_11654(ChiseledPillarBlock.PILLAR_SHAPE))).toString();
        }
        class_265 class_2652 = shape = state.method_28498(ChiseledPillarBlock.PILLAR_SHAPE) ? ChiselHudRenderer.getCustomChiseledShapeForPart(part) : state.method_26218((class_1922)client.field_1687, pos);
        if (shape.method_1110()) {
            return;
        }
        class_243 camPos = context.camera().method_19326();
        class_4587 matrices = context.matrixStack();
        class_4597.class_4598 buffer = client.method_22940().method_23000();
        class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_23594());
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (class_238 box : shape.method_1090()) {
            if (box.field_1323 < minX) {
                minX = box.field_1323;
            }
            if (box.field_1322 < minY) {
                minY = box.field_1322;
            }
            if (box.field_1321 < minZ) {
                minZ = box.field_1321;
            }
            if (box.field_1320 > maxX) {
                maxX = box.field_1320;
            }
            if (box.field_1325 > maxY) {
                maxY = box.field_1325;
            }
            if (!(box.field_1324 > maxZ)) continue;
            maxZ = box.field_1324;
        }
        class_238 mergedBox = new class_238((double)pos.method_10263() + minX - camPos.field_1352, (double)pos.method_10264() + minY - camPos.field_1351, (double)pos.method_10260() + minZ - camPos.field_1350, (double)pos.method_10263() + maxX - camPos.field_1352, (double)pos.method_10264() + maxY - camPos.field_1351, (double)pos.method_10260() + maxZ - camPos.field_1350);
        float outlineThickness = 0.005f;
        float[][] offsets = new float[][]{{0.0f, 0.0f, 0.0f}, {outlineThickness, 0.0f, 0.0f}, {-outlineThickness, 0.0f, 0.0f}, {0.0f, outlineThickness, 0.0f}, {0.0f, -outlineThickness, 0.0f}, {0.0f, 0.0f, outlineThickness}, {0.0f, 0.0f, -outlineThickness}, {outlineThickness, outlineThickness, 0.0f}, {-outlineThickness, -outlineThickness, 0.0f}, {outlineThickness, 0.0f, outlineThickness}, {-outlineThickness, 0.0f, -outlineThickness}, {0.0f, outlineThickness, outlineThickness}, {0.0f, -outlineThickness, -outlineThickness}};
        boolean RainbowOutline = state.method_27852(AllBlocks.OXIDIZABLE_COPPER);
        if (RainbowOutline) {
            float baseHue = ((float)client.field_1687.method_8510() + client.method_1488()) % 360.0f / 360.0f;
            for (int i = 0; i < offsets.length; ++i) {
                class_238 outlineBox = mergedBox.method_989((double)offsets[i][0], (double)offsets[i][1], (double)offsets[i][2]);
                float hueStart = (baseHue + (float)i / (float)offsets.length) % 1.0f;
                float hueEnd = (hueStart + 0.1f) % 1.0f;
                int rgbStart = Color.HSBtoRGB(hueStart, 1.0f, 1.0f);
                int rgbEnd = Color.HSBtoRGB(hueEnd, 1.0f, 1.0f);
                float rStart = (float)(rgbStart >> 16 & 0xFF) / 255.0f;
                float gStart = (float)(rgbStart >> 8 & 0xFF) / 255.0f;
                float bStart = (float)(rgbStart & 0xFF) / 255.0f;
                float rEnd = (float)(rgbEnd >> 16 & 0xFF) / 255.0f;
                float gEnd = (float)(rgbEnd >> 8 & 0xFF) / 255.0f;
                float bEnd = (float)(rgbEnd & 0xFF) / 255.0f;
                ChiselHudRenderer.drawGradientBoxEdges(matrices, vertexConsumer, outlineBox, alpha, rStart, gStart, bStart, rEnd, gEnd, bEnd);
            }
        } else {
            class_3620 mapColor = state.method_26205((class_1922)client.field_1687, pos);
            if (mapColor == null) {
                return;
            }
            int baseColor = mapColor.field_16011;
            int rInt = Math.min((int)((float)(baseColor >> 16 & 0xFF) * 1.5f), 255);
            int gInt = Math.min((int)((float)(baseColor >> 8 & 0xFF) * 1.5f), 255);
            int bInt = Math.min((int)((float)(baseColor & 0xFF) * 1.5f), 255);
            float r = (float)rInt / 255.0f;
            float g = (float)gInt / 255.0f;
            float b = (float)bInt / 255.0f;
            for (float[] offset : offsets) {
                class_238 outlineBox = mergedBox.method_989((double)offset[0], (double)offset[1], (double)offset[2]);
                class_761.method_22980((class_4587)matrices, (class_4588)vertexConsumer, (double)outlineBox.field_1323, (double)outlineBox.field_1322, (double)outlineBox.field_1321, (double)outlineBox.field_1320, (double)outlineBox.field_1325, (double)outlineBox.field_1324, (float)r, (float)g, (float)b, (float)alpha);
            }
        }
        buffer.method_22993();
    }

    private static void drawGradientBoxEdges(class_4587 matrices, class_4588 vertexConsumer, class_238 box, float alpha, float rStart, float gStart, float bStart, float rEnd, float gEnd, float bEnd) {
        class_243[] corners = new class_243[]{new class_243(box.field_1323, box.field_1322, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1324), new class_243(box.field_1323, box.field_1322, box.field_1324), new class_243(box.field_1323, box.field_1325, box.field_1321), new class_243(box.field_1320, box.field_1325, box.field_1321), new class_243(box.field_1320, box.field_1325, box.field_1324), new class_243(box.field_1323, box.field_1325, box.field_1324)};
        int[][] edges = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}};
        Matrix4f matrix = matrices.method_23760().method_23761();
        int light = 0xF000F0;
        for (int[] edge : edges) {
            class_243 start = corners[edge[0]];
            class_243 end = corners[edge[1]];
            Vector4f startPos = new Vector4f((float)start.field_1352, (float)start.field_1351, (float)start.field_1350, 1.0f);
            Vector4f endPos = new Vector4f((float)end.field_1352, (float)end.field_1351, (float)end.field_1350, 1.0f);
            matrix.transform(startPos);
            matrix.transform(endPos);
            vertexConsumer.method_22912((double)startPos.x, (double)startPos.y, (double)startPos.z).method_22915(rStart, gStart, bStart, alpha).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            vertexConsumer.method_22912((double)endPos.x, (double)endPos.y, (double)endPos.z).method_22915(rEnd, gEnd, bEnd, alpha).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        }
    }

    private static class_265 getCustomChiseledShapeForPart(String part) {
        switch (part.toLowerCase()) {
            case "base": {
                return class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
            }
            case "below": {
                class_265 shape1 = class_2248.method_9541((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
                return class_259.method_17786((class_265)shape1, (class_265[])new class_265[0]);
            }
            case "top": {
                class_265 top1 = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
                return class_259.method_17786((class_265)top1, (class_265[])new class_265[0]);
            }
        }
        return class_259.method_1077();
    }

    public class ChiselRenderState {
        public static long lastChiselUseTime = -1L;
    }
}

