/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.block.custom.chiseled_pillars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.chris.chris_s_additions.block.AllBlocks;
import net.chris.chris_s_additions.block.custom.chiseled_pillars.ChiseledPillarBlock;
import net.chris.chris_s_additions.block.custom.properties.PillarShape;
import net.chris.chris_s_additions.item.AllItems;
import net.chris.chris_s_additions.item.custom.ChiselItem;
import net.chris.chris_s_additions.screen.ChiselHudRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ChiseledPillarPatternBlock
extends ChiseledPillarBlock
implements class_3737 {
    public static final class_2754<PillarShape> PILLAR_SHAPE = class_2754.method_11850((String)"shape", PillarShape.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 LOCKED = class_2746.method_11825((String)"locked");
    public static final class_2746 PATTERNED = class_2746.method_11825((String)"patterned");
    private static final Map<class_2338, Long> lastClickTimes = new HashMap<class_2338, Long>();
    private static final long COOLDOWN_TICKS = 10L;
    class_6862<class_2248> THREE_CANAL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "3_canal_pillars"));
    class_6862<class_2248> FOUR_CANAL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "4_canal_pillars"));
    class_6862<class_2248> NO_CANAL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "no_canal_pillars"));
    class_6862<class_2248> SIX_CANAL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "6_canal_pillars"));
    class_6862<class_2248> ALL_CONNECTION = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "all_connection_pillars"));

    public ChiseledPillarPatternBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PILLAR_SHAPE, (Comparable)((Object)PillarShape.DEFAULT))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)PATTERNED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PILLAR_SHAPE, WATERLOGGED, FACING, LOCKED, PATTERNED});
    }

    @Override
    public boolean canConnect(class_2680 state, class_2680 other) {
        if (!(other.method_26204() instanceof ChiseledPillarBlock)) {
            return false;
        }
        if (other.method_28498((class_2769)LOCKED) && ((Boolean)other.method_11654((class_2769)LOCKED)).booleanValue()) {
            return false;
        }
        class_6880 entry = class_7923.field_41175.method_40264(state.method_26204().method_40142().method_40237()).orElse(null);
        class_6880 otherEntry = class_7923.field_41175.method_40264(other.method_26204().method_40142().method_40237()).orElse(null);
        if (entry == null || otherEntry == null) {
            return false;
        }
        if (entry.method_40220(this.ALL_CONNECTION) || otherEntry.method_40220(this.ALL_CONNECTION)) {
            return true;
        }
        return entry.method_40220(this.THREE_CANAL) && otherEntry.method_40220(this.THREE_CANAL) || entry.method_40220(this.FOUR_CANAL) && otherEntry.method_40220(this.FOUR_CANAL) || entry.method_40220(this.NO_CANAL) && otherEntry.method_40220(this.NO_CANAL) || entry.method_40220(this.SIX_CANAL) && otherEntry.method_40220(this.SIX_CANAL);
    }

    private class_2680 getUpdatedState(class_1937 world, class_2338 pos) {
        class_2680 current = world.method_8320(pos);
        if (current.method_28498((class_2769)LOCKED) && ((Boolean)current.method_11654((class_2769)LOCKED)).booleanValue()) {
            return (class_2680)current.method_11657(PILLAR_SHAPE, (Comparable)((Object)PillarShape.DEFAULT));
        }
        boolean down = this.canConnect(current, world.method_8320(pos.method_10074()));
        boolean up = this.canConnect(current, world.method_8320(pos.method_10084()));
        PillarShape shape = PillarShape.DEFAULT;
        if (down && up) {
            shape = PillarShape.BASE;
        } else if (down) {
            shape = PillarShape.TOP;
        } else if (up) {
            shape = PillarShape.BELOW;
        }
        boolean wasPatterned = (Boolean)current.method_11654((class_2769)PATTERNED);
        if (shape != PillarShape.BASE && wasPatterned) {
            current = (class_2680)current.method_11657((class_2769)PATTERNED, (Comparable)Boolean.valueOf(false));
        }
        return (class_2680)current.method_11657(PILLAR_SHAPE, (Comparable)((Object)shape));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluid = ctx.method_8045().method_8316(ctx.method_8037());
        class_2350 playerFacing = ctx.method_8042().method_10153();
        boolean sneaking = ctx.method_8036() != null && ctx.method_8036().method_5715();
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)playerFacing)).method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(sneaking))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.method_39360((class_3611)class_3612.field_15910)))).method_11657((class_2769)PATTERNED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (((Boolean)state.method_11654((class_2769)LOCKED)).booleanValue()) {
            return (class_2680)state.method_11657(PILLAR_SHAPE, (Comparable)((Object)PillarShape.DEFAULT));
        }
        return this.getUpdatedState((class_1937)world, pos);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (((Boolean)state.method_11654((class_2769)LOCKED)).booleanValue()) {
            return;
        }
        class_2680 updated = this.getUpdatedState(world, pos);
        if (updated != state) {
            world.method_8652(pos, updated, 3);
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2680 updatedState;
        boolean isBase;
        long cooldown;
        class_1799 heldItem = player.method_5998(hand);
        if (!(heldItem.method_7909() instanceof ChiselItem)) {
            return class_1269.field_5811;
        }
        long currentTime = world.method_8510();
        long l = cooldown = heldItem.method_31574(AllItems.GOLDEN_CHISEL) ? 7L : 10L;
        if (this.isOnCooldown(pos, currentTime, heldItem, cooldown)) {
            return class_1269.field_5814;
        }
        class_2248 originalBlock = state.method_26204();
        if (world.method_8608()) {
            this.spawnParticles(world, state, pos, originalBlock);
            return class_1269.field_5812;
        }
        this.setLastClickTime(pos, currentTime);
        boolean bl = isBase = state.method_11654(PILLAR_SHAPE) == PillarShape.BASE;
        if (isBase) {
            boolean newPattern = (Boolean)state.method_11654((class_2769)PATTERNED) == false;
            updatedState = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)PATTERNED, (Comparable)Boolean.valueOf(newPattern))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)))).method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)LOCKED, (Comparable)((Boolean)state.method_11654((class_2769)LOCKED)));
            world.method_33596((class_1297)player, newPattern ? class_5712.field_28174 : class_5712.field_28175, pos);
            class_3414 sound = this.getChiselingSound(state.method_26204());
            world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
        } else {
            boolean newLocked = (Boolean)state.method_11654((class_2769)LOCKED) == false;
            updatedState = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(newLocked))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)))).method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)PATTERNED, (Comparable)((Boolean)state.method_11654((class_2769)PATTERNED)));
            world.method_33596((class_1297)player, newLocked ? class_5712.field_28174 : class_5712.field_28175, pos);
            player.method_7353((class_2561)class_2561.method_43470((String)(newLocked ? "The state is locked!" : "The state is unlocked!")), true);
            class_3414 sound = this.getChiselingSound(state.method_26204());
            world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
        }
        heldItem.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
        updatedState = (class_2680)((class_2680)((class_2680)((class_2680)this.getUpdatedState(world, pos).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)updatedState.method_11654((class_2769)WATERLOGGED)))).method_11657((class_2769)FACING, (Comparable)((class_2350)updatedState.method_11654((class_2769)FACING)))).method_11657((class_2769)PATTERNED, (Comparable)((Boolean)updatedState.method_11654((class_2769)PATTERNED)))).method_11657((class_2769)LOCKED, (Comparable)((Boolean)updatedState.method_11654((class_2769)LOCKED)));
        world.method_8652(pos, updatedState, 3);
        this.spawnParticles(world, state, pos, originalBlock);
        ChiselHudRenderer.ChiselRenderState.setLastChiselUse(class_310.method_1551());
        return class_1269.field_5812;
    }

    private void spawnParticles(class_1937 world, class_2680 state, class_2338 pos, class_2248 block) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, block.method_9564()), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 35, 0.3, 0.3, 0.3, 0.05);
        }
    }

    private class_3414 getChiselingSound(class_2248 block) {
        if (block == AllBlocks.SOUL_SLATE_CHISELED_PILLAR || block == AllBlocks.POSSESSED_SOUL_SLATE_CHISELED_PILLAR) {
            return class_3417.field_28968;
        }
        return class_3417.field_15026;
    }

    private boolean isOnCooldown(class_2338 pos, long currentTime, class_1799 stack, long customCooldown) {
        Long lastTime = lastClickTimes.get(pos);
        return lastTime != null && currentTime - lastTime < customCooldown;
    }

    private void setLastClickTime(class_2338 pos, long time) {
        lastClickTimes.put(pos, time);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.method_9530(state, world, pos, context);
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.chiseled_pillar_info").method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.addAll(this.wrapText(class_2561.method_43471((String)"tooltip.chiseled_pillar_chisel_locked_info").getString(), 40));
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.addAll(this.wrapText(class_2561.method_43471((String)"tooltip.chiseled_pillar_chisel_patterned_info").getString(), 40));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"Hold \u00a7e[SHIFT]\u00a7r for more info").method_27692(class_124.field_1080));
        }
    }

    private List<class_2561> wrapText(String text, int maxLength) {
        ArrayList<class_2561> wrappedLines = new ArrayList<class_2561>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() + word.length() > maxLength) {
                wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
                line = new StringBuilder();
            }
            line.append(word).append(" ");
        }
        if (!line.isEmpty()) {
            wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
        }
        return wrappedLines;
    }
}

