/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.block.custom.gravestones;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.chris.chris_s_additions.block.AllBlocks;
import net.chris.chris_s_additions.block.custom.gravestones.AbstractGravestoneBlock;
import net.chris.chris_s_additions.item.AllItems;
import net.chris.chris_s_additions.item.custom.ChiselItem;
import net.chris.chris_s_additions.screen.ChiselHudRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1778;
import net.minecraft.class_1786;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class SoulSlateGravestoneBlock
extends AbstractGravestoneBlock {
    public static final class_2758 FRONT_PATTERN = class_2758.method_11867((String)"front_pattern", (int)0, (int)4);
    public static final class_2758 BACK_PATTERN = class_2758.method_11867((String)"back_pattern", (int)0, (int)4);
    private static final Map<String, Long> chiselCooldowns = new HashMap<String, Long>();
    private static final int CHISEL_COOLDOWN_TICKS = 10;

    public SoulSlateGravestoneBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FRONT_PATTERN, (Comparable)Integer.valueOf(0))).method_11657((class_2769)BACK_PATTERN, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FRONT_PATTERN, BACK_PATTERN});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        long cooldown;
        class_1799 heldItem = player.method_5998(hand);
        boolean isFlintAndSteel = heldItem.method_7909() instanceof class_1786;
        boolean isFireCharge = heldItem.method_7909() instanceof class_1778;
        if (isFlintAndSteel || isFireCharge) {
            if (!world.field_9236) {
                class_2680 newState = (class_2680)((class_2680)((class_2680)((class_2680)AllBlocks.POSSESSED_SOUL_SLATE_GRAVESTONE.method_9564().method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)))).method_11657((class_2769)BACK_PATTERN, (Comparable)((Integer)state.method_11654((class_2769)BACK_PATTERN)))).method_11657((class_2769)FRONT_PATTERN, (Comparable)((Integer)state.method_11654((class_2769)FRONT_PATTERN)));
                world.method_8652(pos, newState, 3);
                if (isFlintAndSteel) {
                    world.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, 1.0f);
                    heldItem.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                } else {
                    world.method_8396(null, pos, class_3417.field_15013, class_3419.field_15245, 1.0f, 1.0f);
                    if (!player.method_31549().field_7477) {
                        heldItem.method_7934(1);
                    }
                }
                world.method_8396(null, pos, class_3417.field_23060, class_3419.field_15245, 1.0f, 1.0f);
            } else {
                double baseX = hit.method_17784().field_1352;
                double baseY = hit.method_17784().field_1351;
                double baseZ = hit.method_17784().field_1350;
                class_2350 face = hit.method_17780();
                double offset = 0.08;
                double spread = 0.6;
                int count = 8;
                double nx = face.method_10148();
                double ny = face.method_10164();
                double nz = face.method_10165();
                for (int i = 0; i < count; ++i) {
                    double px = baseX + nx * offset;
                    double py = baseY + ny * offset;
                    double pz = baseZ + nz * offset;
                    double vx = 0.0;
                    double vy = 0.02;
                    double vz = 0.0;
                    switch (face.method_10166()) {
                        case field_11048: {
                            py += (world.field_9229.method_43058() - 0.5) * spread;
                            pz += (world.field_9229.method_43058() - 0.5) * spread;
                            vy += (world.field_9229.method_43058() - 0.5) * 0.03;
                            vz = (world.field_9229.method_43058() - 0.5) * 0.03;
                            break;
                        }
                        case field_11052: {
                            px += (world.field_9229.method_43058() - 0.5) * spread;
                            pz += (world.field_9229.method_43058() - 0.5) * spread;
                            vx = (world.field_9229.method_43058() - 0.5) * 0.03;
                            vz = (world.field_9229.method_43058() - 0.5) * 0.03;
                            break;
                        }
                        case field_11051: {
                            px += (world.field_9229.method_43058() - 0.5) * spread;
                            py += (world.field_9229.method_43058() - 0.5) * spread;
                            vx = (world.field_9229.method_43058() - 0.5) * 0.03;
                            vy += (world.field_9229.method_43058() - 0.5) * 0.03;
                        }
                    }
                    world.method_8406((class_2394)class_2398.field_22246, px, py, pz, vx, vy, vz);
                    world.method_8406((class_2394)class_2398.field_23114, px, py, pz, vx * 0.5, vy * 0.5, vz * 0.5);
                }
            }
            return class_1269.field_5812;
        }
        if (!(heldItem.method_7909() instanceof ChiselItem) || world.field_9236) {
            return class_1269.field_5811;
        }
        class_243 hitPos = hit.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        if (hitPos.field_1351 <= 0.125) {
            return class_1269.field_5811;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2350 hitSide = hit.method_17780();
        class_2758 propertyToChange = null;
        if (hitSide == facing) {
            propertyToChange = FRONT_PATTERN;
        } else if (hitSide == facing.method_10153()) {
            propertyToChange = BACK_PATTERN;
        } else {
            return class_1269.field_5811;
        }
        String key = player.method_5845() + "_" + pos.method_10063();
        long currentTime = world.method_8510();
        long lastTime = chiselCooldowns.getOrDefault(key, 0L);
        long l = cooldown = heldItem.method_31574(AllItems.GOLDEN_CHISEL) ? 7L : 10L;
        if (currentTime - lastTime < cooldown) {
            return class_1269.field_21466;
        }
        int currentPattern = (Integer)state.method_11654((class_2769)propertyToChange);
        int maxPattern = 4;
        int newPattern = (currentPattern + 1) % (maxPattern + 1);
        class_2680 newState = (class_2680)state.method_11657((class_2769)propertyToChange, (Comparable)Integer.valueOf(newPattern));
        world.method_8652(pos, newState, 3);
        world.method_8396(null, pos, class_3417.field_28973, class_3419.field_15245, 1.0f, 1.0f);
        heldItem.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            double spawnX = (double)pos.method_10263() + hitPos.field_1352;
            double spawnY = (double)pos.method_10264() + hitPos.field_1351;
            double spawnZ = (double)pos.method_10260() + hitPos.field_1350;
            serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, state), spawnX, spawnY, spawnZ, 12, 0.05, 0.05, 0.05, 0.02);
            for (int i = 0; i < 6; ++i) {
                serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, state), spawnX, spawnY, spawnZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        chiselCooldowns.put(key, currentTime);
        ChiselHudRenderer.ChiselRenderState.setLastChiselUse(class_310.method_1551());
        return class_1269.field_5812;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(world, pos, state);
        int front = (Integer)state.method_11654((class_2769)FRONT_PATTERN);
        int back = (Integer)state.method_11654((class_2769)BACK_PATTERN);
        if (front > 0 || back > 0) {
            class_2487 nbt = stack.method_7948();
            nbt.method_10569("FrontPattern", front);
            nbt.method_10569("BackPattern", back);
        }
        return stack;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List drops = super.method_9560(state, builder);
        if (!drops.isEmpty()) {
            class_1799 drop = (class_1799)drops.get(0);
            int front = (Integer)state.method_11654((class_2769)FRONT_PATTERN);
            int back = (Integer)state.method_11654((class_2769)BACK_PATTERN);
            if (front > 0 || back > 0) {
                class_2487 nbt = drop.method_7948();
                nbt.method_10569("FrontPattern", front);
                nbt.method_10569("BackPattern", back);
            }
        }
        return drops;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2487 nbt;
        if (itemStack.method_7985() && (nbt = itemStack.method_7969()) != null && (nbt.method_10545("FrontPattern") || nbt.method_10545("BackPattern"))) {
            int front = nbt.method_10550("FrontPattern");
            int back = nbt.method_10550("BackPattern");
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)FRONT_PATTERN, (Comparable)Integer.valueOf(front))).method_11657((class_2769)BACK_PATTERN, (Comparable)Integer.valueOf(back)), 3);
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 context) {
        class_2487 nbt;
        super.method_9568(stack, world, tooltip, context);
        boolean hasPatternTooltip = false;
        if (stack.method_7985() && (nbt = stack.method_7969()) != null) {
            int front = nbt.method_10550("FrontPattern");
            int back = nbt.method_10550("BackPattern");
            if (front > 0) {
                tooltip.add((class_2561)class_2561.method_43470((String)this.getPatternName(front, true)).method_27692(class_124.field_1080));
                hasPatternTooltip = true;
            }
            if (back > 0) {
                tooltip.add((class_2561)class_2561.method_43470((String)this.getPatternName(back, false)).method_27692(class_124.field_1080));
                hasPatternTooltip = true;
            }
        }
        if (hasPatternTooltip) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
        }
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.lit_tooltip").method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.addAll(this.wrapText(class_2561.method_43471((String)"tooltip.gravestone_info").getString(), 35));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"Hold \u00a7e[SHIFT]\u00a7r for more info").method_27692(class_124.field_1080));
        }
    }

    private String getPatternName(int pattern, boolean isFront) {
        String side = isFront ? "Front" : "Back";
        return switch (pattern) {
            case 1 -> "[Cross] " + side + " Pattern";
            case 2 -> "[Skull] " + side + " Pattern";
            case 3 -> "[Screaming Souls] " + side + " Pattern";
            case 4 -> "[Ghast] " + side + " Pattern";
            default -> side + " Pattern";
        };
    }

    private List<class_2561> wrapText(String text, int maxLength) {
        ArrayList<class_2561> wrappedLines = new ArrayList<class_2561>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() + word.length() > maxLength) {
                wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
                line = new StringBuilder();
            }
            line.append(word).append(" ");
        }
        if (!line.isEmpty()) {
            wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
        }
        return wrappedLines;
    }
}

