/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.chris.chris_s_additions.events.KeyInputHandler;

public class SimpleConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;
    private static ConfigData data;

    public static void init(File configDir) {
        configFile = new File(configDir, "chris_s_additions_config.json");
        SimpleConfig.load();
    }

    public static void load() {
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                data = new ConfigData();
            }
        } else {
            SimpleConfig.save();
        }
        try {
            KeyInputHandler.GuidanceBlockOutlineMode mode;
            KeyInputHandler.guidanceblockoutlineMode = mode = KeyInputHandler.GuidanceBlockOutlineMode.valueOf(SimpleConfig.data.guidanceblockoutlineMode);
        }
        catch (IllegalArgumentException e) {
            KeyInputHandler.guidanceblockoutlineMode = KeyInputHandler.GuidanceBlockOutlineMode.ON;
        }
    }

    public static void save() {
        SimpleConfig.data.guidanceblockoutlineMode = KeyInputHandler.guidanceblockoutlineMode.name();
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        data = new ConfigData();
    }

    public static class ConfigData {
        public String guidanceblockoutlineMode = KeyInputHandler.GuidanceBlockOutlineMode.FADING.name();
    }
}

