/*
 * Decompiled with CFR 0.152.
 */
package net.chris.chris_s_additions.block.custom.chiseled_pillars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.chris.chris_s_additions.block.AllBlocks;
import net.chris.chris_s_additions.block.custom.properties.PillarShape;
import net.chris.chris_s_additions.item.custom.ChiselItem;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ChiseledPillarBlock
extends class_2248
implements class_3737 {
    public static final class_2754<PillarShape> PILLAR_SHAPE = class_2754.method_11850((String)"shape", PillarShape.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 LOCKED = class_2746.method_11825((String)"locked");
    private static final Map<class_2338, Long> lastClickTimes = new HashMap<class_2338, Long>();
    private static final long COOLDOWN_TICKS = 10L;
    class_6862<class_2248> THREE_CANAL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "3_canal_pillars"));
    class_6862<class_2248> FOUR_CANAL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "4_canal_pillars"));
    class_6862<class_2248> NO_CANAL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "no_canal_pillars"));
    class_6862<class_2248> SIX_CANAL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "6_canal_pillars"));
    class_6862<class_2248> ALL_CONNECTION = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("chris_s_additions", "all_connection_pillars"));

    public ChiseledPillarBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PILLAR_SHAPE, (Comparable)((Object)PillarShape.DEFAULT))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PILLAR_SHAPE, WATERLOGGED, FACING, LOCKED});
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        class_2350 playerFacing = ctx.method_8042().method_10153();
        boolean sneaking = ctx.method_8036() != null && ctx.method_8036().method_5715();
        return (class_2680)((class_2680)((class_2680)this.getUpdatedState(ctx.method_8045(), ctx.method_8037()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_39360((class_3611)class_3612.field_15910)))).method_11657((class_2769)FACING, (Comparable)playerFacing)).method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(sneaking));
    }

    private class_2680 getUpdatedState(class_1937 world, class_2338 pos) {
        class_2680 currentState = world.method_8320(pos);
        if (currentState.method_26204() instanceof ChiseledPillarBlock && currentState.method_28498((class_2769)LOCKED) && ((Boolean)currentState.method_11654((class_2769)LOCKED)).booleanValue()) {
            return (class_2680)this.method_9564().method_11657(PILLAR_SHAPE, (Comparable)((Object)PillarShape.DEFAULT));
        }
        class_2680 below = world.method_8320(pos.method_10074());
        class_2680 above = world.method_8320(pos.method_10084());
        boolean hasBlockBelow = this.canConnect(world.method_8320(pos), below);
        boolean hasBlockAbove = this.canConnect(world.method_8320(pos), above);
        PillarShape shape = hasBlockBelow && hasBlockAbove ? PillarShape.BASE : (hasBlockBelow ? PillarShape.TOP : (hasBlockAbove ? PillarShape.BELOW : PillarShape.DEFAULT));
        return (class_2680)this.method_9564().method_11657(PILLAR_SHAPE, (Comparable)((Object)shape));
    }

    public boolean canConnect(class_2680 state, class_2680 otherState) {
        if (!(otherState.method_26204() instanceof ChiseledPillarBlock)) {
            return false;
        }
        if (otherState.method_26204() instanceof ChiseledPillarBlock && otherState.method_28498((class_2769)LOCKED) && ((Boolean)otherState.method_11654((class_2769)LOCKED)).booleanValue()) {
            return false;
        }
        class_6880 blockEntry = class_7923.field_41175.method_40264(state.method_26204().method_40142().method_40237()).orElse(null);
        class_6880 otherBlockEntry = class_7923.field_41175.method_40264(otherState.method_26204().method_40142().method_40237()).orElse(null);
        if (blockEntry == null || otherBlockEntry == null) {
            return false;
        }
        if (blockEntry.method_40220(this.ALL_CONNECTION) || otherBlockEntry.method_40220(this.ALL_CONNECTION)) {
            return true;
        }
        if (blockEntry.method_40220(this.THREE_CANAL) && otherBlockEntry.method_40220(this.THREE_CANAL)) {
            return true;
        }
        if (blockEntry.method_40220(this.FOUR_CANAL) && otherBlockEntry.method_40220(this.FOUR_CANAL)) {
            return true;
        }
        if (blockEntry.method_40220(this.NO_CANAL) && otherBlockEntry.method_40220(this.NO_CANAL)) {
            return true;
        }
        return blockEntry.method_40220(this.SIX_CANAL) && otherBlockEntry.method_40220(this.SIX_CANAL);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (((Boolean)state.method_11654((class_2769)LOCKED)).booleanValue()) {
            return;
        }
        class_2680 updatedState = (class_2680)((class_2680)((class_2680)this.getUpdatedState(world, pos).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)))).method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)LOCKED, (Comparable)((Boolean)state.method_11654((class_2769)LOCKED)));
        if (updatedState != state) {
            world.method_8652(pos, updatedState, 3);
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_265 method_9549(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        return this.method_9530(state, view, pos, context);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (((Boolean)state.method_11654((class_2769)LOCKED)).booleanValue()) {
            return (class_2680)state.method_11657(PILLAR_SHAPE, (Comparable)((Object)PillarShape.DEFAULT));
        }
        return (class_2680)((class_2680)((class_2680)this.getUpdatedState((class_1937)world, pos).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)))).method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)LOCKED, (Comparable)((Boolean)state.method_11654((class_2769)LOCKED)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldItem = player.method_5998(hand);
        if (heldItem.method_7909() instanceof ChiselItem) {
            long currentTime = world.method_8510();
            class_2248 originalBlock = state.method_26204();
            if (world.method_8608()) {
                if (this.isOnCooldown(pos, currentTime)) {
                    return class_1269.field_5814;
                }
                this.spawnParticles(world, state, pos, originalBlock);
                return class_1269.field_5812;
            }
            if (this.isOnCooldown(pos, currentTime)) {
                return class_1269.field_5814;
            }
            this.setLastClickTime(pos, currentTime);
            boolean newLockedState = (Boolean)state.method_11654((class_2769)LOCKED) == false;
            class_2680 updatedState = (class_2680)state.method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(newLockedState));
            updatedState = (class_2680)((class_2680)((class_2680)this.getUpdatedState(world, pos).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)updatedState.method_11654((class_2769)WATERLOGGED)))).method_11657((class_2769)FACING, (Comparable)((class_2350)updatedState.method_11654((class_2769)FACING)))).method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(newLockedState));
            heldItem.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            world.method_8652(pos, updatedState, 3);
            world.method_33596((class_1297)player, newLockedState ? class_5712.field_28174 : class_5712.field_28175, pos);
            class_3414 sound = this.getChiselingSound(state.method_26204());
            if (newLockedState) {
                player.method_7353((class_2561)class_2561.method_43470((String)"The state is locked!"), true);
                world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"The state is unlocked!"), true);
                world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
            }
            this.spawnParticles(world, state, pos, originalBlock);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void spawnParticles(class_1937 world, class_2680 state, class_2338 pos, class_2248 originalBlock) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, originalBlock.method_9564()), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 35, 0.3, 0.3, 0.3, 0.05);
        }
    }

    private class_3414 getChiselingSound(class_2248 block) {
        if (block == AllBlocks.DEEPSLATE_CHISELED_PILLAR) {
            return class_3417.field_28973;
        }
        if (block == AllBlocks.CALCITE_CHISELED_PILLAR) {
            return class_3417.field_26948;
        }
        if (block == AllBlocks.DRIPSTONE_CHISELED_PILLAR) {
            return class_3417.field_28038;
        }
        if (block == AllBlocks.BASALT_CHISELED_PILLAR) {
            return class_3417.field_21867;
        }
        if (block == AllBlocks.NETHER_BRICK_CHISELED_PILLAR || block == AllBlocks.RED_NETHER_BRICK_CHISELED_PILLAR) {
            return class_3417.field_21882;
        }
        if (block == AllBlocks.IRON_CHISELED_PILLAR || block == AllBlocks.GOLD_CHISELED_PILLAR || block == AllBlocks.ROSE_GOLD_CHISELED_PILLAR || block == AllBlocks.REDSTONE_CHISELED_PILLAR || block == AllBlocks.EMERALD_CHISELED_PILLAR || block == AllBlocks.DIAMOND_CHISELED_PILLAR) {
            return class_3417.field_15044;
        }
        if (block == AllBlocks.COPPER_CHISELED_PILLAR || block == AllBlocks.WAXED_COPPER_CHISELED_PILLAR || block == AllBlocks.EXPOSED_COPPER_CHISELED_PILLAR || block == AllBlocks.WAXED_EXPOSED_COPPER_CHISELED_PILLAR || block == AllBlocks.WEATHERED_COPPER_CHISELED_PILLAR || block == AllBlocks.WAXED_WEATHERED_COPPER_CHISELED_PILLAR || block == AllBlocks.OXIDIZED_COPPER_CHISELED_PILLAR || block == AllBlocks.WAXED_OXIDIZED_COPPER_CHISELED_PILLAR) {
            return class_3417.field_26960;
        }
        if (block == AllBlocks.AMETHYST_CHISELED_PILLAR) {
            return class_3417.field_26979;
        }
        if (block == AllBlocks.NETHERITE_CHISELED_PILLAR) {
            return class_3417.field_21919;
        }
        return class_3417.field_15026;
    }

    private boolean isOnCooldown(class_2338 pos, long currentTime) {
        return lastClickTimes.containsKey(pos) && currentTime - lastClickTimes.get(pos) < 10L;
    }

    private void setLastClickTime(class_2338 pos, long currentTime) {
        lastClickTimes.put(pos, currentTime);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.chiseled_pillar_info").method_27692(class_124.field_1068));
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.addAll(this.wrapText(class_2561.method_43471((String)"tooltip.chiseled_pillar_chisel_locked_info").getString(), 35));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"Hold \u00a7e[SHIFT]\u00a7r for more info").method_27692(class_124.field_1080));
        }
    }

    private List<class_2561> wrapText(String text, int maxLength) {
        ArrayList<class_2561> wrappedLines = new ArrayList<class_2561>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() + word.length() > maxLength) {
                wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
                line = new StringBuilder();
            }
            line.append(word).append(" ");
        }
        if (!line.isEmpty()) {
            wrappedLines.add((class_2561)class_2561.method_43470((String)line.toString()).method_27692(class_124.field_1068));
        }
        return wrappedLines;
    }
}

