/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.block;

import com.google.common.collect.Sets;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.capabilityproxy.blockentity.BlockEntityCapabilityProxyCommon;
import org.cyclops.cyclopscore.block.BlockWithEntityCommon;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntityCommon;

public class BlockCapabilityProxy
extends BlockWithEntityCommon {
    public final MapCodec<BlockCapabilityProxy> codec = BlockBehaviour.simpleCodec(p -> new BlockCapabilityProxy((BlockBehaviour.Properties)p, blockEntitySupplier));
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty INACTIVE = BooleanProperty.create((String)"inactive");
    private Set<BlockPos> activatingBlockChain = null;

    public BlockCapabilityProxy(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, ? extends CyclopsBlockEntityCommon> blockEntitySupplier) {
        super(properties, blockEntitySupplier);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)INACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{INACTIVE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)INACTIVE, (Comparable)Boolean.valueOf(context.getLevel().getBlockEntity(BlockEntityCapabilityProxyCommon.getTargetPos(context.getClickedPos(), context.getClickedFace().getOpposite())) == null));
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (this.activatingBlockChain == null) {
            this.activatingBlockChain = Sets.newHashSet((Object[])new BlockPos[]{pos});
        } else {
            if (this.activatingBlockChain.contains(pos)) {
                return InteractionResult.FAIL;
            }
            this.activatingBlockChain.add(pos);
        }
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        BlockState targetBlockState = level.getBlockState(pos.relative(facing));
        InteractionResult ret = targetBlockState.useWithoutItem(level, player, hit.withDirection(facing.getOpposite()).withPosition(BlockEntityCapabilityProxyCommon.getTargetPos(pos, facing)));
        this.activatingBlockChain = null;
        return ret;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean inactive;
        Direction facing;
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.isClientSide && pos.relative(facing = (Direction)state.getValue((Property)FACING)).equals((Object)fromPos) && (inactive = ((Boolean)state.getValue((Property)INACTIVE)).booleanValue()) != (world.getBlockEntity(pos.relative(facing)) == null)) {
            world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)INACTIVE, (Comparable)Boolean.valueOf(!inactive)));
            world.updateNeighborsAtExceptFromFacing(pos, (Block)this, facing);
        }
    }
}

