/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.block.BlockWithEntityCommon;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntityCommon;

public class BlockEntityCapabilityProxy
extends BlockWithEntityCommon {
    public final MapCodec<BlockEntityCapabilityProxy> codec = BlockBehaviour.simpleCodec(p -> new BlockEntityCapabilityProxy((BlockBehaviour.Properties)p, blockEntitySupplier));
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public BlockEntityCapabilityProxy(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, ? extends CyclopsBlockEntityCommon> blockEntitySupplier) {
        super(properties, blockEntitySupplier);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (hit.getDirection() == facing) {
            return InteractionResult.SUCCESS;
        }
        BlockPos targetPos = pos.relative(facing);
        List entities = worldIn.getEntitiesOfClass(Entity.class, new AABB(targetPos));
        for (Entity entity : entities) {
            InteractionResult result = entity.interactAt(player, new Vec3((double)targetPos.getX() + 0.5 - entity.getX(), (double)targetPos.getY() + 0.5 - entity.getY(), (double)targetPos.getZ() + 0.5 - entity.getZ()), player.getUsedItemHand());
            if (result != InteractionResult.PASS) {
                return result;
            }
            result = player.interactOn(entity, player.getUsedItemHand());
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }
}

