/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.cyclops.capabilityproxy.CapabilityProxyNeoForge;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.blockentity.BlockEntityEntityCapabilityProxyNeoForge;
import org.cyclops.cyclopscore.config.extendedconfig.BlockEntityConfig;
import org.cyclops.cyclopscore.init.ModBase;

public class BlockEntityEntityCapabilityProxyNeoForgeConfig
extends BlockEntityConfig<BlockEntityEntityCapabilityProxyNeoForge> {
    public BlockEntityEntityCapabilityProxyNeoForgeConfig() {
        super((ModBase)CapabilityProxyNeoForge._instance, "entity_capability_proxy", eConfig -> new BlockEntityType(BlockEntityEntityCapabilityProxyNeoForge::new, (Set)Sets.newHashSet((Object[])new Block[]{(Block)RegistryEntries.BLOCK_ENTITY_CAPABILITY_PROXY.value()}), null));
        CapabilityProxyNeoForge._instance.getModEventBus().addListener(this::registerCapabilities);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        BlockEntityEntityCapabilityProxyNeoForge.BLOCK_TO_ENTITY_CAPABILITIES = Maps.newIdentityHashMap();
        HashMap namedEntityCapabilities = Maps.newHashMap();
        for (EntityCapability entityCapability : EntityCapability.getAll()) {
            namedEntityCapabilities.put(entityCapability.name().toString(), entityCapability);
        }
        for (BlockCapability blockCapability : BlockCapability.getAll()) {
            event.registerBlockEntity(blockCapability, (BlockEntityType)this.getInstance(), (object, context) -> object.getCapability(blockCapability));
            EntityCapability entityCapability = (EntityCapability)namedEntityCapabilities.get(blockCapability.name().toString());
            if (entityCapability == null) continue;
            BlockEntityEntityCapabilityProxyNeoForge.BLOCK_TO_ENTITY_CAPABILITIES.put(blockCapability, entityCapability);
        }
    }
}

