/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.block.BlockItemCapabilityProxy;
import org.cyclops.capabilityproxy.inventory.container.ContainerItemCapabilityProxy;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntityCommon;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventoryCommon;

public class BlockEntityItemCapabilityProxyCommon
extends CyclopsBlockEntityCommon
implements MenuProvider {
    private final SimpleInventoryCommon inventory = new SimpleInventoryCommon(1, 1){

        public void setItem(int slotId, ItemStack itemstack) {
            boolean wasEmpty = this.getItem(slotId).isEmpty();
            super.setItem(slotId, itemstack);
            boolean isEmpty = itemstack.isEmpty();
            if (wasEmpty != isEmpty) {
                BlockEntityItemCapabilityProxyCommon.this.getLevel().setBlockAndUpdate(BlockEntityItemCapabilityProxyCommon.this.getBlockPos(), (BlockState)BlockEntityItemCapabilityProxyCommon.this.getLevel().getBlockState(BlockEntityItemCapabilityProxyCommon.this.getBlockPos()).setValue((Property)BlockItemCapabilityProxy.INACTIVE, (Comparable)Boolean.valueOf(isEmpty)));
            } else {
                IModHelpers.get().getBlockHelpers().markForUpdate(BlockEntityItemCapabilityProxyCommon.this.getLevel(), BlockEntityItemCapabilityProxyCommon.this.getBlockPos());
            }
            BlockEntityItemCapabilityProxyCommon.this.onInventoryChanged();
        }
    };

    public BlockEntityItemCapabilityProxyCommon(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.TILE_ENTITY_ITEM_CAPABILITY_PROXY.value(), blockPos, blockState);
    }

    protected void onInventoryChanged() {
    }

    public void read(CompoundTag tag, HolderLookup.Provider provider) {
        super.read(tag, provider);
        this.inventory.read(provider, tag);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.inventory.write(provider, tag);
    }

    public SimpleInventoryCommon getInventory() {
        return this.inventory;
    }

    public Direction getFacing() {
        return (Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(this.getLevel().getBlockState(this.getBlockPos()), (Property)BlockItemCapabilityProxy.FACING, (Comparable)Direction.UP);
    }

    protected ItemStack getContents() {
        return this.inventory.getItem(0);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.capabilityproxy.item_capability_proxy");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new ContainerItemCapabilityProxy(id, playerInventory, (Container)this.getInventory());
    }
}

