/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.cyclops.capabilityproxy.CapabilityProxyNeoForge;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.blockentity.BlockEntityItemCapabilityProxyNeoForge;
import org.cyclops.cyclopscore.config.extendedconfig.BlockEntityConfig;
import org.cyclops.cyclopscore.init.ModBase;

public class BlockEntityItemCapabilityProxyNeoForgeConfig
extends BlockEntityConfig<BlockEntityItemCapabilityProxyNeoForge> {
    public BlockEntityItemCapabilityProxyNeoForgeConfig() {
        super((ModBase)CapabilityProxyNeoForge._instance, "item_capability_proxy", eConfig -> new BlockEntityType(BlockEntityItemCapabilityProxyNeoForge::new, (Set)Sets.newHashSet((Object[])new Block[]{(Block)RegistryEntries.BLOCK_ITEM_CAPABILITY_PROXY.value()}), null));
        CapabilityProxyNeoForge._instance.getModEventBus().addListener(this::registerCapabilities);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        BlockEntityItemCapabilityProxyNeoForge.BLOCK_TO_ITEM_CAPABILITIES = Maps.newIdentityHashMap();
        HashMap namedItemCapabilities = Maps.newHashMap();
        for (ItemCapability itemCapability : ItemCapability.getAll()) {
            namedItemCapabilities.put(itemCapability.name().toString(), itemCapability);
        }
        for (BlockCapability blockCapability : BlockCapability.getAll()) {
            event.registerBlockEntity(blockCapability, (BlockEntityType)this.getInstance(), (object, context) -> object.getCapability(blockCapability, context));
            ItemCapability itemCapability = (ItemCapability)namedItemCapabilities.get(blockCapability.name().toString());
            if (itemCapability == null) continue;
            BlockEntityItemCapabilityProxyNeoForge.BLOCK_TO_ITEM_CAPABILITIES.put(blockCapability, itemCapability);
        }
    }
}

