/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.block.BlockCapabilityProxy;
import org.cyclops.capabilityproxy.block.BlockEntityCapabilityProxy;
import org.cyclops.capabilityproxy.block.BlockItemCapabilityProxy;
import org.cyclops.capabilityproxy.block.BlockRangedCapabilityProxy;
import org.cyclops.capabilityproxy.blockentity.BlockEntityItemCapabilityProxyCommon;

public class GameTestsCommon {
    public static final String TEMPLATE_EMPTY = "capabilityproxy:empty10";
    public static final BlockPos POS = BlockPos.ZERO;

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyPlacementDirection(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.SOUTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value(), POS.south());
            helper.assertBlockProperty(POS.south(), (Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH);
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyPlacementDirectionOpposite(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.NORTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value(), POS.north());
            helper.assertBlockProperty(POS.north(), (Property)BlockCapabilityProxy.FACING, (Comparable)Direction.SOUTH);
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyPlacementInactive(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.offset(2, 2, 2), Direction.SOUTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value(), POS.offset(2, 2, 3));
            helper.assertBlockProperty(POS.offset(2, 2, 3), (Property)BlockCapabilityProxy.INACTIVE, (Comparable)Boolean.valueOf(true));
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyPlacementActive(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.offset(2, 2, 2), Direction.SOUTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value(), POS.offset(2, 2, 3));
            helper.assertBlockProperty(POS.offset(2, 2, 3), (Property)BlockCapabilityProxy.INACTIVE, (Comparable)Boolean.valueOf(false));
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyForwardItemHopper(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        helper.setBlock(POS.offset(2, 2, 3), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.NORTH));
        helper.spawnItem(Items.APPLE, POS.offset(2, 3, 4));
        helper.succeedWhen(() -> this.assertChestContains(helper, POS.offset(2, 2, 2), new ItemStack((ItemLike)Items.APPLE)));
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyForwardChainItemHopper(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        helper.setBlock(POS.offset(2, 2, 3), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 3, 4), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 4), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 5), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 4, 5), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.WEST));
        helper.setBlock(POS.offset(3, 5, 5), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.spawnItem(Items.APPLE, POS.offset(3, 6, 5));
        helper.succeedWhen(() -> this.assertChestContains(helper, POS.offset(2, 2, 2), new ItemStack((ItemLike)Items.APPLE)));
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyCycleItem(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.EAST));
        helper.setBlock(POS.offset(2, 2, 3), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 2, 3), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.WEST));
        helper.setBlock(POS.offset(3, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.SOUTH));
        helper.setBlock(POS.offset(2, 3, 2), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.spawnItem(Items.APPLE, POS.offset(2, 4, 2));
        helper.succeedIf(() -> helper.assertAtTickTimeContainerContains(10L, POS.offset(2, 4, 2), Items.APPLE));
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyForwardGuiHopper(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        helper.setBlock(POS.offset(2, 2, 3), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.succeedIf(() -> {
            BlockState blockState = helper.getBlockState(POS.offset(2, 2, 3));
            InteractionResult result = blockState.useWithoutItem((Level)helper.getLevel(), player, new BlockHitResult(POS.offset(2, 2, 3).getBottomCenter(), Direction.NORTH, helper.absolutePos(POS.offset(2, 2, 3)), false));
            helper.assertTrue(result.equals((Object)InteractionResult.CONSUME), "Interaction failed");
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyForwardChainGuiHopper(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        helper.setBlock(POS.offset(2, 2, 3), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 3, 4), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 4), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 5), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 4, 5), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.WEST));
        helper.setBlock(POS.offset(3, 5, 5), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.DOWN));
        helper.succeedWhen(() -> {
            BlockState blockState = helper.getBlockState(POS.offset(3, 5, 5));
            InteractionResult result = blockState.useWithoutItem((Level)helper.getLevel(), player, new BlockHitResult(POS.offset(3, 5, 5).getBottomCenter(), Direction.NORTH, helper.absolutePos(POS.offset(3, 5, 5)), false));
            helper.assertTrue(result.equals((Object)InteractionResult.CONSUME), "Interaction failed");
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyCycleGui(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.EAST));
        helper.setBlock(POS.offset(2, 2, 3), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 2, 3), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.WEST));
        helper.setBlock(POS.offset(3, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.SOUTH));
        helper.succeedWhen(() -> {
            BlockState blockState = helper.getBlockState(POS.offset(2, 2, 2));
            InteractionResult result = blockState.useWithoutItem((Level)helper.getLevel(), player, new BlockHitResult(POS.offset(2, 2, 2).getBottomCenter(), Direction.NORTH, helper.absolutePos(POS.offset(2, 2, 2)), false));
            helper.assertTrue(result.equals((Object)InteractionResult.FAIL), "Interaction did not fail");
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyRangedPlacementDirection(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_RANGED_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.SOUTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value(), POS.south());
            helper.assertBlockProperty(POS.south(), (Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH);
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyRangedPlacementDirectionOpposite(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_RANGED_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.NORTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value(), POS.north());
            helper.assertBlockProperty(POS.north(), (Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.SOUTH);
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyRangedForwardItemHopper(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 5), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.NORTH));
        helper.spawnItem(Items.APPLE, POS.offset(2, 3, 5));
        helper.succeedWhen(() -> this.assertChestContains(helper, POS.offset(2, 2, 2), new ItemStack((ItemLike)Items.APPLE)));
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyRangedForwardChainItemHopper(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 5), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 3, 5), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 5), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 6), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 4, 6), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.WEST));
        helper.setBlock(POS.offset(3, 5, 6), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.spawnItem(Items.APPLE, POS.offset(3, 6, 6));
        helper.succeedWhen(() -> this.assertChestContains(helper, POS.offset(2, 2, 2), new ItemStack((ItemLike)Items.APPLE)));
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyRangedCycleItem(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.EAST));
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(4, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.WEST));
        helper.setBlock(POS.offset(4, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.SOUTH));
        helper.setBlock(POS.offset(2, 3, 2), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.spawnItem(Items.APPLE, POS.offset(2, 4, 2));
        helper.succeedIf(() -> helper.assertAtTickTimeContainerContains(10L, POS.offset(2, 4, 2), Items.APPLE));
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyRangedForwardGuiHopper(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.succeedIf(() -> {
            BlockState blockState = helper.getBlockState(POS.offset(2, 2, 4));
            InteractionResult result = blockState.useWithoutItem((Level)helper.getLevel(), player, new BlockHitResult(POS.offset(2, 2, 4).getBottomCenter(), Direction.NORTH, helper.absolutePos(POS.offset(2, 2, 4)), false));
            helper.assertTrue(result.equals((Object)InteractionResult.CONSUME), "Interaction failed");
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyRangedForwardChainGuiHopper(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 5), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 3, 5), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 5), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 6), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 4, 6), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.WEST));
        helper.setBlock(POS.offset(3, 5, 6), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.DOWN));
        helper.succeedWhen(() -> {
            BlockState blockState = helper.getBlockState(POS.offset(3, 5, 6));
            InteractionResult result = blockState.useWithoutItem((Level)helper.getLevel(), player, new BlockHitResult(POS.offset(3, 5, 6).getBottomCenter(), Direction.NORTH, helper.absolutePos(POS.offset(3, 5, 6)), false));
            helper.assertTrue(result.equals((Object)InteractionResult.CONSUME), "Interaction failed");
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyRangedCycleGui(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.EAST));
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(4, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.WEST));
        helper.setBlock(POS.offset(4, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.SOUTH));
        helper.succeedWhen(() -> {
            BlockState blockState = helper.getBlockState(POS.offset(2, 2, 2));
            InteractionResult result = blockState.useWithoutItem((Level)helper.getLevel(), player, new BlockHitResult(POS.offset(2, 2, 2).getBottomCenter(), Direction.NORTH, helper.absolutePos(POS.offset(2, 2, 2)), false));
            helper.assertTrue(result.equals((Object)InteractionResult.PASS) || result.equals((Object)InteractionResult.FAIL), "Interaction did not pass");
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyMixedRangedForwardChainItemHopper(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), Blocks.CHEST);
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 2, 5), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(2, 3, 5), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 5), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.offset(2, 4, 6), (BlockState)((Block)RegistryEntries.BLOCK_RANGED_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockRangedCapabilityProxy.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 4, 6), (BlockState)((Block)RegistryEntries.BLOCK_CAPABILITY_PROXY.value()).defaultBlockState().setValue((Property)BlockCapabilityProxy.FACING, (Comparable)Direction.WEST));
        helper.setBlock(POS.offset(3, 5, 6), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.spawnItem(Items.APPLE, POS.offset(3, 6, 6));
        helper.succeedWhen(() -> this.assertChestContains(helper, POS.offset(2, 2, 2), new ItemStack((ItemLike)Items.APPLE)));
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyItemPlacementDirection(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ITEM_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.SOUTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_ITEM_CAPABILITY_PROXY.value(), POS.south());
            helper.assertBlockProperty(POS.south(), (Property)BlockItemCapabilityProxy.FACING, (Comparable)Direction.NORTH);
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyItemPlacementDirectionOpposite(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ITEM_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.NORTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_ITEM_CAPABILITY_PROXY.value(), POS.north());
            helper.assertBlockProperty(POS.north(), (Property)BlockItemCapabilityProxy.FACING, (Comparable)Direction.SOUTH);
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyItemPlacementInactive(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ITEM_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.offset(2, 2, 2), Direction.SOUTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_ITEM_CAPABILITY_PROXY.value(), POS.offset(2, 2, 3));
            helper.assertBlockProperty(POS.offset(2, 2, 3), (Property)BlockItemCapabilityProxy.INACTIVE, (Comparable)Boolean.valueOf(true));
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyItemPlacementActive(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ITEM_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.offset(2, 2, 2), Direction.SOUTH);
        BlockEntityItemCapabilityProxyCommon blockEntity = (BlockEntityItemCapabilityProxyCommon)helper.getBlockEntity(POS.offset(2, 2, 3));
        blockEntity.getInventory().setItem(0, new ItemStack((ItemLike)Items.WATER_BUCKET));
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_ITEM_CAPABILITY_PROXY.value(), POS.offset(2, 2, 3));
            helper.assertBlockProperty(POS.offset(2, 2, 3), (Property)BlockItemCapabilityProxy.INACTIVE, (Comparable)Boolean.valueOf(false));
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyItemFillShulkerBoxFromHopper(GameTestHelper helper) {
        if (!this.isNeoForge()) {
            helper.succeed();
            return;
        }
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ITEM_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.offset(2, 2, 2), Direction.SOUTH);
        BlockEntityItemCapabilityProxyCommon blockEntity = (BlockEntityItemCapabilityProxyCommon)helper.getBlockEntity(POS.offset(2, 2, 3));
        blockEntity.getInventory().setItem(0, new ItemStack((ItemLike)Items.SHULKER_BOX));
        helper.setBlock(POS.offset(2, 2, 4), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.NORTH));
        helper.spawnItem(Items.APPLE, POS.offset(2, 3, 4));
        helper.succeedWhen(() -> {
            ItemStack itemStackFilled = blockEntity.getInventory().getItem(0);
            ItemContainerContents container = (ItemContainerContents)itemStackFilled.get(DataComponents.CONTAINER);
            if (!container.stream().anyMatch(i -> i.getItem() == Items.APPLE)) {
                throw new GameTestAssertException("Shulker box in item proxy contains no apple");
            }
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyEntityPlacementDirection(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ENTITY_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.SOUTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_ENTITY_CAPABILITY_PROXY.value(), POS.south());
            helper.assertBlockProperty(POS.south(), (Property)BlockEntityCapabilityProxy.FACING, (Comparable)Direction.NORTH);
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyEntityPlacementDirectionOpposite(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ENTITY_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.NORTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_ENTITY_CAPABILITY_PROXY.value(), POS.north());
            helper.assertBlockProperty(POS.north(), (Property)BlockEntityCapabilityProxy.FACING, (Comparable)Direction.SOUTH);
        });
    }

    @GameTest(template="capabilityproxy:empty10")
    public void testBlockProxyEntityFillChestMinecartFromHopper(GameTestHelper helper) {
        if (!this.isNeoForge() && !this.isForge()) {
            helper.succeed();
            return;
        }
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ENTITY_CAPABILITY_PROXY.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.offset(2, 0, 2), Direction.SOUTH);
        helper.setBlock(POS.offset(2, 0, 2), Blocks.RAIL.defaultBlockState());
        MinecartChest minecart = (MinecartChest)helper.spawn(EntityType.CHEST_MINECART, POS.offset(2, 0, 2));
        helper.setBlock(POS.offset(2, 0, 4), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.NORTH));
        helper.spawnItem(Items.APPLE, POS.offset(2, 1, 4));
        helper.succeedWhen(() -> {
            if (minecart.getItem(0).getItem() != Items.APPLE) {
                throw new GameTestAssertException("Chest minecart targeted by entity proxy contains no apple");
            }
        });
    }

    protected void assertChestContains(GameTestHelper helper, BlockPos pos, ItemStack itemStack) {
        helper.assertBlockEntityData(pos, chest -> ItemStack.isSameItemSameComponents((ItemStack)chest.getItem(0), (ItemStack)itemStack), () -> "Chest is not empty");
    }

    protected boolean isNeoForge() {
        try {
            Class.forName("net.neoforged.neoforge.common.NeoForge");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected boolean isForge() {
        try {
            Class.forName("net.minecraftforge.common.MinecraftForge");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

