/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.apilookup;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiLookupMap;
import net.fabricmc.fabric.impl.lookup.custom.ApiLookupMapImpl;
import net.minecraft.class_2960;

public class TypedApiHelpers {
    public static <T> ApiLookupMap<T> getTypedApiLookupsMap(Class<T> clazz) {
        try {
            Field lookupsField = clazz.getDeclaredField("LOOKUPS");
            lookupsField.setAccessible(true);
            return (ApiLookupMap)lookupsField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <L> Map<class_2960, Object> getApiLookupMap(ApiLookupMapImpl lookupMap) {
        try {
            Field lookupsField = ApiLookupMapImpl.class.getDeclaredField("lookups");
            lookupsField.setAccessible(true);
            return (Map)lookupsField.get(lookupMap);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Map<class_2960, T> getTypedApiLookupsKeyed(Class<T> clazz) {
        HashMap lookups = Maps.newHashMap();
        Map<class_2960, Object> map = TypedApiHelpers.getApiLookupMap((ApiLookupMapImpl)TypedApiHelpers.getTypedApiLookupsMap(clazz));
        for (class_2960 id : map.keySet()) {
            Object lookupHolder = map.get(id);
            try {
                Field lookupField = lookupHolder.getClass().getDeclaredField("lookup");
                lookupField.setAccessible(true);
                lookups.put(id, lookupField.get(lookupHolder));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return lookups;
    }

    public static <T> Collection<T> getTypedApiLookups(Class<T> clazz) {
        return TypedApiHelpers.getTypedApiLookupsKeyed(clazz).values();
    }
}

