/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.block;

import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.cyclops.capabilityproxy.block.BlockRangedCapabilityProxyConfig;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;

public class BlockRangedCapabilityProxy
extends BlockWithEntity {
    public final MapCodec<BlockRangedCapabilityProxy> codec = BlockBehaviour.simpleCodec(p -> new BlockRangedCapabilityProxy((BlockBehaviour.Properties)p, blockEntitySupplier));
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;

    public BlockRangedCapabilityProxy(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, ? extends CyclopsBlockEntity> blockEntitySupplier) {
        super(properties, blockEntitySupplier);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        RecursiveHit rhit;
        RecursiveHit recursiveHit = rhit = hit instanceof RecursiveHit ? (RecursiveHit)hit : new RecursiveHit(hit, new HashSet<BlockPos>(), hit.getBlockPos(), hit.getDirection());
        if (rhit.chain.contains(pos)) {
            rhit.setFailed();
            return InteractionResult.FAIL;
        }
        rhit.chain.add(pos.immutable());
        for (int offset = 1; offset < BlockRangedCapabilityProxyConfig.range; ++offset) {
            Direction facing = (Direction)state.getValue(FACING);
            BlockPos targetPos = pos.relative(facing, offset);
            BlockState target = worldIn.getBlockState(targetPos);
            InteractionResult ret = target.useWithoutItem(worldIn, player, (BlockHitResult)rhit.move(targetPos, facing.getOpposite()));
            if (!ret.consumesAction() && !rhit.failed) continue;
            return ret;
        }
        return InteractionResult.PASS;
    }

    private static class RecursiveHit
    extends BlockHitResult {
        private RecursiveHit rParent;
        private final BlockHitResult parent;
        private final Set<BlockPos> chain;
        private boolean failed = false;

        public RecursiveHit(BlockHitResult parent, Set<BlockPos> chain, BlockPos pos, Direction face) {
            super(parent.getLocation(), face, pos, parent.isInside());
            this.parent = parent;
            this.chain = chain;
        }

        private RecursiveHit(RecursiveHit parent, Direction face) {
            this(parent.parent, parent.chain, parent.getBlockPos(), face);
            this.rParent = parent;
        }

        private RecursiveHit move(BlockPos pos, Direction face) {
            return new RecursiveHit(this.parent, this.chain, pos, face);
        }

        public BlockHitResult withDirection(Direction newFace) {
            return new RecursiveHit(this, newFace);
        }

        public HitResult.Type getType() {
            return this.parent.getType();
        }

        public Vec3 getLocation() {
            return this.parent.getLocation();
        }

        public boolean isInside() {
            return this.parent.isInside();
        }

        public void setFailed() {
            if (this.rParent != null) {
                this.rParent.setFailed();
            } else {
                this.failed = true;
            }
        }
    }
}

