/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.capabilityproxy.CapabilityProxyForge;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.blockentity.BlockEntityCapabilityProxyCommon;

public class BlockEntityCapabilityProxyForge
extends BlockEntityCapabilityProxyCommon {
    private final Map<Pair<BlockPos, Capability<?>>, LazyOptional<?>> cachedCapabilities = Maps.newHashMap();

    public BlockEntityCapabilityProxyForge(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.TILE_ENTITY_CAPABILITY_PROXY.value(), blockPos, blockState);
    }

    protected BlockEntityCapabilityProxyForge(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public static BlockPos getTargetPos(BlockPos source, Direction facing) {
        return source.relative(facing);
    }

    protected BlockPos getTargetPos(Level worldIn, @Nullable Capability<?> capability, BlockPos source) {
        return BlockEntityCapabilityProxyForge.getTargetPos(source, this.getFacing());
    }

    protected <T> LazyOptional<T> getTarget(Capability<T> capability, BlockGetter world, BlockPos pos, Direction facing) {
        return BlockEntityCapabilityProxyForge.getCapabilityCached(this.cachedCapabilities, capability, pos, () -> CapabilityProxyForge._instance.getModHelpers().getCapabilityHelpers().getCapability(world, pos, facing, capability));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (this.handling) {
            return LazyOptional.empty();
        }
        this.handling = true;
        LazyOptional<T> ret = this.getTarget(capability, (BlockGetter)this.getLevel(), this.getTargetPos(this.getLevel(), capability, this.getBlockPos()), this.getFacing().getOpposite());
        this.handling = false;
        return ret == null ? LazyOptional.empty() : ret;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<?> value : this.cachedCapabilities.values()) {
            value.invalidate();
        }
        this.cachedCapabilities.clear();
    }

    public static <T, C> LazyOptional<T> getCapabilityCached(Map<Pair<C, Capability<?>>, LazyOptional<?>> cachedCapabilities, Capability<T> capability, C cacheParam, Supplier<LazyOptional<T>> capabilitySupplier) {
        Pair cacheKey = Pair.of(cacheParam, capability);
        LazyOptional<?> cachedCapability = cachedCapabilities.get(cacheKey);
        if (cachedCapability != null) {
            return cachedCapability;
        }
        LazyOptional<T> innerCapability = capabilitySupplier.get();
        if (!innerCapability.isPresent()) {
            return LazyOptional.empty();
        }
        LazyOptional outerCapability = innerCapability.lazyMap(a -> a);
        cachedCapabilities.put(cacheKey, outerCapability);
        innerCapability.addListener(a -> {
            outerCapability.invalidate();
            cachedCapabilities.remove(cacheKey);
        });
        return outerCapability;
    }
}

