/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.capabilityproxy.blockentity.BlockEntityCapabilityProxyForge;
import org.cyclops.capabilityproxy.blockentity.BlockEntityEntityCapabilityProxyCommon;

public class BlockEntityEntityCapabilityProxyForge
extends BlockEntityEntityCapabilityProxyCommon {
    private final Map<Pair<Integer, Capability<?>>, LazyOptional<?>> cachedCapabilities = Maps.newHashMap();

    public BlockEntityEntityCapabilityProxyForge(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    protected List<Entity> getEntities(Capability<?> capability) {
        AABB aabb = new AABB(this.getBlockPos().relative(this.getFacing()));
        Direction facing = this.getFacing().getOpposite();
        return this.getLevel().getEntitiesOfClass(Entity.class, aabb, entity -> entity.getCapability(capability, facing).isPresent());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        List<Entity> entities = this.getEntities(capability);
        if (entities.isEmpty()) {
            return LazyOptional.empty();
        }
        Entity entity = entities.get(0);
        return BlockEntityCapabilityProxyForge.getCapabilityCached(this.cachedCapabilities, capability, entity.getId(), () -> entity.getCapability(capability, this.getFacing().getOpposite()));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<?> value : this.cachedCapabilities.values()) {
            value.invalidate();
        }
        this.cachedCapabilities.clear();
    }
}

