/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.capabilityproxy.blockentity.BlockEntityCapabilityProxyForge;
import org.cyclops.capabilityproxy.blockentity.BlockEntityItemCapabilityProxyCommon;
import org.cyclops.cyclopscore.fluid.FluidHandlerWrapperForge;

public class BlockEntityItemCapabilityProxyForge
extends BlockEntityItemCapabilityProxyCommon {
    private final Map<Pair<String, Capability<?>>, LazyOptional<?>> cachedCapabilities = Maps.newHashMap();

    public BlockEntityItemCapabilityProxyForge(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    @Override
    protected void onInventoryChanged() {
        super.onInventoryChanged();
        this.invalidateCapsCached();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        boolean transformFluidCapability;
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> new InvWrapper((Container)this.getInventory()));
        }
        boolean bl = transformFluidCapability = capability == ForgeCapabilities.FLUID_HANDLER;
        if (transformFluidCapability) {
            capability = ForgeCapabilities.FLUID_HANDLER_ITEM;
        }
        if (facing == this.getFacing()) {
            return super.getCapability(capability, facing);
        }
        ItemStack itemStack = this.getContents();
        Capability finalCapability = capability;
        return BlockEntityCapabilityProxyForge.getCapabilityCached(this.cachedCapabilities, capability, "", () -> {
            LazyOptional cap = BlockEntityItemCapabilityProxyForge.getItemStackCapability(finalCapability, itemStack, facing);
            if (transformFluidCapability) {
                cap = cap.cast().lazyMap(fluidHandler -> new FluidHandlerWrapperItem((IFluidHandlerItem)fluidHandler, this)).cast();
            }
            return cap;
        });
    }

    public static <T> LazyOptional<T> getItemStackCapability(Capability<T> capability, ItemStack itemStack, Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER_ITEM && itemStack.getItem() instanceof BucketItem) {
            return LazyOptional.of(() -> new FluidBucketWrapper(itemStack));
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.invalidateCapsCached();
    }

    protected void invalidateCapsCached() {
        for (LazyOptional<?> value : this.cachedCapabilities.values()) {
            value.invalidate();
        }
        this.cachedCapabilities.clear();
    }

    public static class FluidHandlerWrapperItem
    extends FluidHandlerWrapperForge
    implements IFluidHandlerItem {
        private final IFluidHandlerItem fluidHandler;
        private final BlockEntityItemCapabilityProxyForge tile;

        public FluidHandlerWrapperItem(IFluidHandlerItem fluidHandler, BlockEntityItemCapabilityProxyForge tile) {
            super((IFluidHandler)fluidHandler);
            this.fluidHandler = fluidHandler;
            this.tile = tile;
        }

        protected void updateContainerSlot() {
            this.tile.getInventory().setItem(0, this.getContainer());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int ret = super.fill(resource, action);
            if (action.execute()) {
                this.updateContainerSlot();
            }
            return ret;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack ret = super.drain(maxDrain, action);
            if (action.execute()) {
                this.updateContainerSlot();
            }
            return ret;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack ret = super.drain(resource, action);
            if (action.execute()) {
                this.updateContainerSlot();
            }
            return ret;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.fluidHandler.getContainer();
        }
    }
}

