/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.cyclops.capabilityproxy.CapabilityProxyNeoForge;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.blockentity.BlockEntityEntityCapabilityProxyNeoForge;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.ModConfigLocation;
import org.cyclops.cyclopscore.config.extendedconfig.BlockEntityConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;

public class BlockEntityEntityCapabilityProxyNeoForgeConfig
extends BlockEntityConfigCommon<BlockEntityEntityCapabilityProxyNeoForge, CapabilityProxyNeoForge> {
    @ConfigurablePropertyCommon(category="machine", comment="Names of capabilities that are not marked as proxyable, but must be proxied nonetheless.", requiresMcRestart=true, configLocation=ModConfigLocation.SERVER)
    public static List<String> capabilitiesForceProxable = Lists.newArrayList();

    public BlockEntityEntityCapabilityProxyNeoForgeConfig() {
        super((IModBase)CapabilityProxyNeoForge._instance, "entity_capability_proxy", eConfig -> new BlockEntityType(BlockEntityEntityCapabilityProxyNeoForge::new, (Set)Sets.newHashSet((Object[])new Block[]{(Block)RegistryEntries.BLOCK_ENTITY_CAPABILITY_PROXY.value()})));
        CapabilityProxyNeoForge._instance.getModEventBus().addListener(this::registerCapabilities);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        BlockEntityEntityCapabilityProxyNeoForge.BLOCK_TO_ENTITY_CAPABILITIES = Maps.newIdentityHashMap();
        HashMap namedEntityCapabilities = Maps.newHashMap();
        for (EntityCapability entityCapability : EntityCapability.getAll()) {
            namedEntityCapabilities.put(entityCapability.name().toString(), entityCapability);
        }
        for (BlockCapability blockCapability : BlockCapability.getAll()) {
            if (!CapabilityProxyNeoForge.shouldRegisterCapability(blockCapability, capabilitiesForceProxable)) continue;
            event.registerBlockEntity(blockCapability, (BlockEntityType)this.getInstance(), (object, context) -> object.getCapability(blockCapability));
            EntityCapability entityCapability = (EntityCapability)namedEntityCapabilities.get(blockCapability.name().toString());
            if (entityCapability == null) continue;
            BlockEntityEntityCapabilityProxyNeoForge.BLOCK_TO_ENTITY_CAPABILITIES.put(blockCapability, entityCapability);
        }
    }
}

