/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.cyclops.capabilityproxy.CapabilityProxyNeoForge;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.blockentity.BlockEntityItemCapabilityProxyNeoForge;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.ModConfigLocation;
import org.cyclops.cyclopscore.config.extendedconfig.BlockEntityConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;

public class BlockEntityItemCapabilityProxyNeoForgeConfig
extends BlockEntityConfigCommon<BlockEntityItemCapabilityProxyNeoForge, CapabilityProxyNeoForge> {
    @ConfigurablePropertyCommon(category="machine", comment="Names of capabilities that are not marked as proxyable, but must be proxied nonetheless.", requiresMcRestart=true, configLocation=ModConfigLocation.SERVER)
    public static List<String> capabilitiesForceProxable = Lists.newArrayList();

    public BlockEntityItemCapabilityProxyNeoForgeConfig() {
        super((IModBase)CapabilityProxyNeoForge._instance, "item_capability_proxy", eConfig -> new BlockEntityType(BlockEntityItemCapabilityProxyNeoForge::new, (Set)Sets.newHashSet((Object[])new Block[]{(Block)RegistryEntries.BLOCK_ITEM_CAPABILITY_PROXY.value()})));
        CapabilityProxyNeoForge._instance.getModEventBus().addListener(this::registerCapabilities);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        BlockEntityItemCapabilityProxyNeoForge.BLOCK_TO_ITEM_CAPABILITIES = Maps.newIdentityHashMap();
        HashMap namedItemCapabilities = Maps.newHashMap();
        for (ItemCapability itemCapability : ItemCapability.getAll()) {
            namedItemCapabilities.put(itemCapability.name().toString(), itemCapability);
        }
        for (BlockCapability blockCapability : BlockCapability.getAll()) {
            if (!CapabilityProxyNeoForge.shouldRegisterCapability(blockCapability, capabilitiesForceProxable)) continue;
            event.registerBlockEntity(blockCapability, (BlockEntityType)this.getInstance(), (object, context) -> object.getCapability(blockCapability, context));
            ItemCapability itemCapability = (ItemCapability)namedItemCapabilities.get(blockCapability.name().toString());
            if (itemCapability == null) continue;
            BlockEntityItemCapabilityProxyNeoForge.BLOCK_TO_ITEM_CAPABILITIES.put(blockCapability, itemCapability);
        }
    }
}

