/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.client.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.Vec3;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.block.BlockRangedCapabilityProxyConfig;
import org.cyclops.capabilityproxy.blockentity.BlockEntityCapabilityProxyCommon;

public class RenderTileRangedCapabilityProxy
implements BlockEntityRenderer<BlockEntityCapabilityProxyCommon> {
    public static final RenderType RENDER_TYPE_LINE = RenderType.create((String)"capabilityproxyline", (int)128, (RenderPipeline)RenderPipelines.SECONDARY_BLOCK_OUTLINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setOutputState(RenderStateShard.ITEM_ENTITY_TARGET).createCompositeState(false));

    public RenderTileRangedCapabilityProxy(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityCapabilityProxyCommon tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 cameraPos) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == RegistryEntries.ITEM_RANGED_CAPABILITY_PROXY.value() || player.getItemInHand(InteractionHand.OFF_HAND).getItem() == RegistryEntries.ITEM_RANGED_CAPABILITY_PROXY.value()) {
            float r = 0.28f;
            float g = 0.87f;
            float b = 0.8f;
            float a = 0.6f;
            float x = 0.5f;
            float y = 0.5f;
            float z = 0.5f;
            BlockPos target = new BlockPos(0, 0, 0).relative(tile.getFacing(), BlockRangedCapabilityProxyConfig.range);
            float minX = x;
            float minY = y;
            float minZ = z;
            float maxX = x + (float)target.getX();
            float maxY = y + (float)target.getY();
            float maxZ = z + (float)target.getZ();
            VertexConsumer vb = buffer.getBuffer(RENDER_TYPE_LINE);
            vb.addVertex(matrixStack.last().pose(), minX, minY, minZ).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 0.0f);
            vb.addVertex(matrixStack.last().pose(), maxX, maxY, maxZ).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 0.0f);
        }
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }
}

