/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.cyclops.capabilityproxy.blockentity.BlockEntityItemCapabilityProxyCommon;
import org.cyclops.capabilityproxy.blockentity.BlockEntityItemCapabilityProxyFabricConfig;
import team.reborn.energy.api.EnergyStorage;

public class BlockEntityItemCapabilityProxyFabric
extends BlockEntityItemCapabilityProxyCommon {
    public static Map<BlockApiLookup<?, ?>, ItemApiLookup<?, ?>> BLOCK_TO_ITEM_CAPABILITIES;

    public BlockEntityItemCapabilityProxyFabric(class_2338 blockPos, class_2680 blockState) {
        super(blockPos, blockState);
        BlockEntityItemCapabilityProxyFabricConfig.itemApiRegistrar.initializeCapabilityRegistrationsIfNeeded((class_2591<? extends BlockEntityItemCapabilityProxyFabric>)this.method_11017());
    }

    public <T, C1, C2> T getCapability(BlockApiLookup<T, C1> blockCapability, C1 context) {
        if (context instanceof class_2350 && context == this.getFacing() && blockCapability == ItemStorage.SIDED) {
            return (T)InventoryStorage.of((class_1263)this.getInventory(), (class_2350)((class_2350)context));
        }
        class_1799 itemStack = this.getContents();
        ItemApiLookup<T, C2> itemCapability = BlockEntityItemCapabilityProxyFabric.blockCapabilityToItemCapability(blockCapability);
        if (itemCapability == null) {
            return null;
        }
        class_2350 itemContext = null;
        if (itemCapability.contextClass() == class_2350.class) {
            itemContext = this.getFacing().method_10153();
        }
        if (itemCapability.contextClass() == ContainerItemContext.class) {
            itemContext = ContainerItemContext.ofSingleSlot((SingleSlotStorage)InventoryStorage.of((class_1263)this.getInventory(), (class_2350)((class_2350)context)).getSlot(0));
        }
        return (T)itemCapability.find(itemStack, (Object)itemContext);
    }

    @Nullable
    public static <T, C1, C2> ItemApiLookup<T, C2> blockCapabilityToItemCapability(BlockApiLookup<T, C1> capability) {
        if (capability == FluidStorage.SIDED) {
            return FluidStorage.ITEM;
        }
        if (capability == EnergyStorage.SIDED) {
            return EnergyStorage.ITEM;
        }
        return BLOCK_TO_ITEM_CAPABILITIES.get(capability);
    }
}

