/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityInvalidationListener;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.blockentity.BlockEntityCapabilityProxyCommon;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;

public class BlockEntityCapabilityProxyNeoForge
extends BlockEntityCapabilityProxyCommon {
    private final Map<Pair<BlockPos, BaseCapability<?, ?>>, Pair<?, ICapabilityInvalidationListener>> cachedCapabilities = Maps.newHashMap();

    public BlockEntityCapabilityProxyNeoForge(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.TILE_ENTITY_CAPABILITY_PROXY.value(), blockPos, blockState);
    }

    protected BlockEntityCapabilityProxyNeoForge(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    protected BlockPos getTargetPos(Level worldIn, BlockCapability<?, ?> capability, BlockPos source) {
        return BlockEntityCapabilityProxyNeoForge.getTargetPos(source, this.getFacing());
    }

    protected <T, C> T getTarget(BlockCapability<T, C> capability, Level targetWorld, BlockPos targetPos, C targetContext, Level originWorld, BlockPos originPos) {
        return BlockEntityCapabilityProxyNeoForge.getCapabilityCached(this.cachedCapabilities, capability, targetPos, targetWorld, targetPos, originWorld, originPos, () -> IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)targetWorld, targetPos, targetContext, capability));
    }

    public <T, C> T getCapability(BlockCapability<T, C> capability, C context) {
        if (this.handling) {
            return null;
        }
        this.handling = true;
        T ret = this.getTarget(capability, this.getLevel(), this.getTargetPos(this.getLevel(), capability, this.getBlockPos()), context instanceof Direction ? this.getFacing().getOpposite() : context, this.getLevel(), this.getBlockPos());
        this.handling = false;
        return ret;
    }

    public static <T, C, CACHE> T getCapabilityCached(Map<Pair<CACHE, BaseCapability<?, ?>>, Pair<?, ICapabilityInvalidationListener>> cachedCapabilities, BaseCapability<T, C> capability, CACHE cacheParam, Level targetWorld, BlockPos targetPos, Level originWorld, BlockPos originPos, Supplier<Optional<T>> capabilitySupplier) {
        Pair cacheKey = Pair.of(cacheParam, capability);
        Pair<?, ICapabilityInvalidationListener> cachedCapabilityPair = cachedCapabilities.get(cacheKey);
        if (cachedCapabilityPair != null) {
            return (T)cachedCapabilityPair.getLeft();
        }
        Optional<T> innerCapability = capabilitySupplier.get();
        if (!innerCapability.isPresent()) {
            return null;
        }
        T outerCapability = innerCapability.get();
        if (targetWorld instanceof ServerLevel) {
            ServerLevel targetWorldServer = (ServerLevel)targetWorld;
            ICapabilityInvalidationListener invalidationListener = () -> {
                cachedCapabilities.remove(cacheKey);
                originWorld.invalidateCapabilities(originPos);
                return false;
            };
            cachedCapabilities.put(cacheKey, Pair.of(outerCapability, (Object)invalidationListener));
            targetWorldServer.registerCapabilityListener(targetPos, invalidationListener);
        }
        return outerCapability;
    }
}

