/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.capabilityproxy.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.capabilityproxy.RegistryEntries;
import org.cyclops.capabilityproxy.block.BlockItemCapabilityProxy;
import org.cyclops.capabilityproxy.inventory.container.ContainerItemCapabilityProxy;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class BlockEntityItemCapabilityProxyCommon
extends CyclopsBlockEntity
implements MenuProvider {
    private final SimpleInventory inventory = new SimpleInventory(1, 1){

        public void setItem(int slotId, ItemStack itemstack) {
            boolean wasEmpty = this.getItem(slotId).isEmpty();
            super.setItem(slotId, itemstack);
            boolean isEmpty = itemstack.isEmpty();
            if (wasEmpty != isEmpty) {
                BlockEntityItemCapabilityProxyCommon.this.getLevel().setBlockAndUpdate(BlockEntityItemCapabilityProxyCommon.this.getBlockPos(), (BlockState)BlockEntityItemCapabilityProxyCommon.this.getLevel().getBlockState(BlockEntityItemCapabilityProxyCommon.this.getBlockPos()).setValue((Property)BlockItemCapabilityProxy.INACTIVE, (Comparable)Boolean.valueOf(isEmpty)));
            } else {
                IModHelpers.get().getBlockHelpers().markForUpdate(BlockEntityItemCapabilityProxyCommon.this.getLevel(), BlockEntityItemCapabilityProxyCommon.this.getBlockPos());
            }
            BlockEntityItemCapabilityProxyCommon.this.onInventoryChanged();
        }
    };

    public BlockEntityItemCapabilityProxyCommon(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.TILE_ENTITY_ITEM_CAPABILITY_PROXY.value(), blockPos, blockState);
    }

    protected void onInventoryChanged() {
    }

    public void read(ValueInput input) {
        super.read(input);
        this.inventory.read(input);
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.inventory.write(output);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public Direction getFacing() {
        return (Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(this.getLevel().getBlockState(this.getBlockPos()), BlockItemCapabilityProxy.FACING, (Comparable)Direction.UP);
    }

    protected ItemStack getContents() {
        return this.inventory.getItem(0);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.capabilityproxy.item_capability_proxy");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new ContainerItemCapabilityProxy(id, playerInventory, (Container)this.getInventory());
    }
}

